/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.accessionregister;

import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterStatsDto;
import java.util.List;

public class AccessRegisterStatsHelper {
    private AccessRegisterStatsHelper() {
        throw new UnsupportedOperationException("Utility class !");
    }

    public static AccessionRegisterStatsDto fetchStats(List<AccessionRegisterDetailModel> accessionRegisterDetailModels) {
        AccessionRegisterStatsDto statsDto = new AccessionRegisterStatsDto();
        Long objectSizes = accessionRegisterDetailModels.parallelStream().map(ardm -> ardm.getObjectSize().getIngested()).reduce(0L, Long::sum);
        Long totalObjects = accessionRegisterDetailModels.parallelStream().map(ardm -> ardm.getTotalObjects().getIngested()).reduce(0L, Long::sum);
        Long totalUnits = accessionRegisterDetailModels.parallelStream().map(ardm -> ardm.getTotalUnits().getIngested()).reduce(0L, Long::sum);
        Long totalObjectsGroups = accessionRegisterDetailModels.parallelStream().map(ardm -> ardm.getTotalObjectsGroups().getIngested()).reduce(0L, Long::sum);
        statsDto.setObjectSizes(objectSizes.longValue());
        statsDto.setTotalObjects(totalObjects.longValue());
        statsDto.setTotalUnits(totalUnits.longValue());
        statsDto.setTotalObjectsGroups(totalObjectsGroups.longValue());
        return statsDto;
    }
}

