/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.accesscontract;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitamui.commons.api.domain.AccessContractModelDto;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.referential.common.dto.AccessContractDto;
import fr.gouv.vitamui.referential.common.dto.AccessContractVitamDto;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AccessContractConverter {
    public AccessContractVitamDto convertDtoToVitam(AccessContractDto dto) {
        AccessContractVitamDto accessContract = (AccessContractVitamDto)VitamUIUtils.copyProperties((Object)dto, (Object)new AccessContractVitamDto());
        return accessContract;
    }

    public AccessContractDto convertVitamToDto(AccessContractVitamDto accessContract) {
        AccessContractDto dto = (AccessContractDto)VitamUIUtils.copyProperties((Object)accessContract, (Object)new AccessContractDto());
        return dto;
    }

    public List<AccessContractModelDto> convertDtosToVitams(List<AccessContractDto> dtos) {
        return dtos.stream().map(this::convertDtoToVitam).collect(Collectors.toList());
    }

    public List<AccessContractDto> convertVitamsToDtos(List<AccessContractVitamDto> accessContracts) {
        return accessContracts.stream().map(this::convertVitamToDto).collect(Collectors.toList());
    }

    JsonNode convertToUpperCaseFields(Map<String, Object> partialDto) {
        ObjectNode propertiesToUpdate = JsonHandler.createObjectNode();
        partialDto.forEach((fieldName, value) -> propertiesToUpdate.putPOJO(StringUtils.capitalize((String)fieldName), value));
        return propertiesToUpdate;
    }
}

