/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.ProfileDto;
import java.io.IOException;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

public class ProfileInternalRestClient
extends BasePaginatingAndSortingRestClient<ProfileDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileInternalRestClient.class);

    public ProfileInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<ProfileDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<ProfileDto>>(){};
    }

    public String getPathUrl() {
        return "/referential/v1/profile";
    }

    protected Class<ProfileDto> getDtoClass() {
        return ProfileDto.class;
    }

    protected ParameterizedTypeReference<List<ProfileDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ProfileDto>>(){};
    }

    public boolean check(InternalHttpContext context, ProfileDto accessContractDto) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/check"));
        HttpEntity request = new HttpEntity((Object)accessContractDto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Boolean.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK;
    }

    public ResponseEntity<Resource> download(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/download/{id}"));
        HttpEntity request = new HttpEntity(null, this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, Resource.class);
    }

    public ResponseEntity<JsonNode> updateProfile(InternalHttpContext context, ProfileDto dto) {
        LOGGER.debug("Update {}", (Object)dto);
        ApiUtils.checkValidity((Object)dto);
        String dtoId = dto.getId();
        HttpEntity request = new HttpEntity((Object)dto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/{id}", HttpMethod.PUT, request, JsonNode.class, new Object[]{dtoId});
        this.checkResponse(response, new Integer[0]);
        return response;
    }

    public ResponseEntity<JsonNode> updateProfileFile(InternalHttpContext context, String id, MultipartFile profileFile) throws IOException {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/updateProfileFile/{id}"));
        LinkedMultiValueMap bodyMap = new LinkedMultiValueMap();
        bodyMap.add((Object)"file", (Object)new FileSystemResource(profileFile.getBytes(), profileFile.getOriginalFilename()));
        HttpEntity request = new HttpEntity((Object)bodyMap, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PUT, request, JsonNode.class);
        this.checkResponse(response, new Integer[0]);
        return response;
    }

    public static class FileSystemResource
    extends ByteArrayResource {
        private String fileName;

        public FileSystemResource(byte[] byteArray, String filename) {
            super(byteArray);
            this.fileName = filename;
        }

        public String getFilename() {
            return this.fileName;
        }

        public void setFilename(String fileName) {
            this.fileName = fileName;
        }
    }
}

