/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OperationInternalRestClient
extends BasePaginatingAndSortingRestClient<LogbookOperationDto, InternalHttpContext> {
    public OperationInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>>(){};
    }

    public String getPathUrl() {
        return "/referential/v1/operations";
    }

    protected Class<LogbookOperationDto> getDtoClass() {
        return LogbookOperationDto.class;
    }

    protected ParameterizedTypeReference<List<LogbookOperationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<LogbookOperationDto>>(){};
    }

    public boolean runAudit(InternalHttpContext context, AuditOptions auditOptions) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        HttpEntity request = new HttpEntity((Object)auditOptions, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Boolean.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK;
    }

    public JsonNode checkTraceabilityOperation(InternalHttpContext context, String id) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/check/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, JsonNode.class);
        this.checkResponse(response, new Integer[0]);
        return (JsonNode)response.getBody();
    }

    public ResponseEntity<Resource> export(InternalHttpContext context, String id, ReportType type) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}/download/{type}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id, type}), HttpMethod.GET, request, Resource.class);
    }

    public boolean runProbativeValue(InternalHttpContext context, ProbativeValueRequest probativeValueOptions) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/probativeValue"));
        HttpEntity request = new HttpEntity((Object)probativeValueOptions, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Boolean.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK;
    }

    public ResponseEntity<Resource> exportProbativeValue(InternalHttpContext context, String operationId) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/probativeValue/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{operationId}), HttpMethod.GET, request, Resource.class);
    }
}

