/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import org.springframework.http.HttpMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

public class OntologyInternalWebClient
extends BaseWebClient<InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyInternalWebClient.class);

    public OntologyInternalWebClient(WebClient webClient, String baseUrl) {
        super(webClient, baseUrl);
    }

    public JsonNode importOntologies(InternalHttpContext context, String fileName, MultipartFile file) {
        if (file == null) {
            LOGGER.error("No file to import");
            throw new BadRequestException("No file to import .");
        }
        LOGGER.debug("Import file {}", (Object)file.getOriginalFilename());
        return (JsonNode)this.multipartData(this.getUrl() + "/import", HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("fileName", fileName), Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("file", file)), JsonNode.class);
    }

    public String getPathUrl() {
        return "/referential/v1/ontology";
    }
}

