/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OntologyInternalRestClient
extends BasePaginatingAndSortingRestClient<OntologyDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyInternalRestClient.class);

    public OntologyInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<OntologyDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<OntologyDto>>(){};
    }

    public String getPathUrl() {
        return "/referential/v1/ontology";
    }

    protected Class<OntologyDto> getDtoClass() {
        return OntologyDto.class;
    }

    protected ParameterizedTypeReference<List<OntologyDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<OntologyDto>>(){};
    }

    public boolean check(InternalHttpContext context, OntologyDto ontologyDto) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/check"));
        HttpEntity request = new HttpEntity((Object)ontologyDto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Boolean.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK;
    }

    public List<VitamUiOntologyDto> getInternalOntologyList(InternalHttpContext context) {
        LOGGER.debug("[INTERNAL] : Calling Get default internal ontology fields list");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/internal-ontologies"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return (List)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, ArrayList.class).getBody();
    }
}

