/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class AgencyInternalRestClient
extends BasePaginatingAndSortingRestClient<AgencyDto, InternalHttpContext> {
    public AgencyInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<AgencyDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<AgencyDto>>(){};
    }

    public String getPathUrl() {
        return "/referential/v1/agency";
    }

    protected Class<AgencyDto> getDtoClass() {
        return AgencyDto.class;
    }

    protected ParameterizedTypeReference<List<AgencyDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<AgencyDto>>(){};
    }

    public boolean check(InternalHttpContext context, AgencyDto accessContractDto) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/check"));
        HttpEntity request = new HttpEntity((Object)accessContractDto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Boolean.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK;
    }

    public ResponseEntity<Resource> export(InternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/export"));
        HttpEntity request = new HttpEntity(null, this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, Resource.class, new Object[0]);
    }

    public boolean deleteAgency(InternalHttpContext context, String id) {
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/{id}", HttpMethod.DELETE, request, Boolean.class, new Object[]{id});
        this.checkResponse(response, new Integer[]{200, 201, 202, 204});
        return response.getStatusCode() == HttpStatus.OK;
    }
}

