/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.client;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

public class AccessContractInternalWebClient
extends BaseWebClient<InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessContractInternalWebClient.class);

    public AccessContractInternalWebClient(WebClient webClient, String baseUrl) {
        super(webClient, baseUrl);
    }

    public ResponseEntity<Void> importAccessContracts(InternalHttpContext context, MultipartFile file) {
        if (file == null) {
            throw new BadRequestException("No file to import .");
        }
        LOGGER.debug("Import file {}", (Object)file.getOriginalFilename());
        return (ResponseEntity)this.multipartData(this.getUrl() + "/import", HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("fileName", file.getOriginalFilename()), Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("file", file)), ResponseEntity.class);
    }

    public String getPathUrl() {
        return "/referential/v1/accesscontracts";
    }
}

