/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.ingest.external.server.service.IngestExternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ingest"})
@RequestMapping(value={"/v1/ingest"})
@RestController
@ResponseBody
public class IngestExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestExternalController.class);
    private final IngestExternalService ingestExternalService;

    @Autowired
    public IngestExternalController(IngestExternalService ingestExternalService) {
        this.ingestExternalService = ingestExternalService;
    }

    @Secured(value={"ROLE_GET_ALL_INGEST"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws PreconditionFailedException, InvalidParseOperationException, IOException {
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        SanityChecker.sanitizeCriteria(criteria);
        if (criteria.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)VitamUIUtils.convertObjectFromJson((String)criteria.get(), Object.class));
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.ingestExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_INGEST"})
    @GetMapping(value={"/{id}"})
    public LogbookOperationDto getOne(@PathVariable(value="id") String id) throws PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get One Ingest id={}", (Object)id);
        return this.ingestExternalService.getOne(id);
    }

    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/odtreport/{id}"})
    public ResponseEntity<byte[]> generateODTReport(@PathVariable(value="id") String id) throws PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter :", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("export ODT report for ingest with id :{}", (Object)id);
        return this.ingestExternalService.generateODTReport(id);
    }

    @Secured(value={"ROLE_CREATE_INGEST"})
    @ApiOperation(value="Upload an streaming SIP", consumes="application/octet-stream")
    @PostMapping(value={"/upload"}, consumes={"application/octet-stream"})
    public ResponseEntity<Void> streamingUpload(InputStream inputStream, @RequestHeader(value="X-Action") String action, @RequestHeader(value="X-Context-Id") String contextId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The action and the context ID are mandatory parameters: ", (String[])new String[]{action, contextId});
        SanityChecker.checkSecureParameter((String[])new String[]{action, contextId});
        LOGGER.debug("[Internal] upload file v2");
        return this.ingestExternalService.streamingUpload(inputStream, contextId, action);
    }
}

