/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.external.server.config;

import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.configuration.SwaggerConfiguration;
import fr.gouv.vitamui.iam.internal.client.IamInternalRestClientFactory;
import fr.gouv.vitamui.iam.internal.client.UserInternalRestClient;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import fr.gouv.vitamui.iam.security.service.ExternalAuthentificationService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.ingest.external.server.config.ApiIngestExternalApplicationProperties;
import fr.gouv.vitamui.ingest.internal.client.IngestInternalRestClient;
import fr.gouv.vitamui.ingest.internal.client.IngestInternalRestClientFactory;
import fr.gouv.vitamui.ingest.internal.client.IngestInternalWebClient;
import fr.gouv.vitamui.ingest.internal.client.IngestInternalWebClientFactory;
import fr.gouv.vitamui.ingest.internal.client.IngestStreamingInternalRestClient;
import fr.gouv.vitamui.ingest.internal.client.IngestStreamingInternalRestClientFactory;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.client.SecurityRestClientFactory;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@Import(value={RestExceptionHandler.class, SwaggerConfiguration.class, HttpMessageConvertersAutoConfiguration.class})
public class ApiIngestServerConfig
extends AbstractContextConfiguration {
    @Bean
    public SecurityRestClientFactory securityRestClientFactory(ApiIngestExternalApplicationProperties apiIngestExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new SecurityRestClientFactory(apiIngestExternalApplicationProperties.getSecurityClient(), restTemplateBuilder);
    }

    @Bean
    public ContextRestClient contextCrudRestClient(SecurityRestClientFactory securityRestClientFactory) {
        return securityRestClientFactory.getContextRestClient();
    }

    @Bean
    public MappingJackson2HttpMessageConverter customizedJacksonMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"), MediaType.APPLICATION_OCTET_STREAM));
        return converter;
    }

    @Bean
    public ExternalApiAuthenticationProvider apiAuthenticationProvider(ExternalAuthentificationService externalAuthentificationService) {
        return new ExternalApiAuthenticationProvider(externalAuthentificationService);
    }

    @Bean
    public ExternalSecurityService externalSecurityService() {
        return new ExternalSecurityService();
    }

    @Bean
    public ExternalAuthentificationService externalAuthentificationService(ContextRestClient contextRestClient, UserInternalRestClient userInternalRestClient) {
        return new ExternalAuthentificationService(contextRestClient, userInternalRestClient);
    }

    @Bean
    public IamInternalRestClientFactory iamInternalRestClientFactory(ApiIngestExternalApplicationProperties apiIngestExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IamInternalRestClientFactory(apiIngestExternalApplicationProperties.getIamInternalClient(), restTemplateBuilder);
    }

    @Bean
    public UserInternalRestClient userInternalRestClient(IamInternalRestClientFactory iamInternalRestClientFactory) {
        return iamInternalRestClientFactory.getUserInternalRestClient();
    }

    @Bean
    public IngestInternalRestClientFactory ingestInternalRestClientFactory(ApiIngestExternalApplicationProperties apiIngestExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IngestInternalRestClientFactory(apiIngestExternalApplicationProperties.getIngestInternalClient(), restTemplateBuilder);
    }

    @Bean
    public IngestStreamingInternalRestClientFactory ingestStreamingInternalRestClientFactory(ApiIngestExternalApplicationProperties apiIngestExternalApplicationProperties) {
        return new IngestStreamingInternalRestClientFactory(apiIngestExternalApplicationProperties.getIngestInternalClient());
    }

    @Bean
    public IngestStreamingInternalRestClient ingestStreamingInternalRestClient(IngestStreamingInternalRestClientFactory factory) {
        return factory.getIngestStreamingInternalRestClient();
    }

    @Bean
    public IngestInternalRestClient ingestInternalRestClient(IngestInternalRestClientFactory factory) {
        return factory.getIngestInternalRestClient();
    }

    @Bean
    public IngestInternalWebClientFactory ingestInternalWebClientFactory(ApiIngestExternalApplicationProperties apiIngestExternalApplicationProperties, RestTemplateBuilder restTemplateBuilder) {
        return new IngestInternalWebClientFactory(apiIngestExternalApplicationProperties.getIngestInternalClient());
    }

    @Bean
    public IngestInternalWebClient ingestInternalWebClient(IngestInternalWebClientFactory factory) {
        return factory.getIngestInternalWebClient();
    }
}

