/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import fr.gouv.vitamui.iam.common.utils.CustomTokenValidator;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.profile.JwtGenerator;
import org.pac4j.oidc.config.OidcConfiguration;

public class CustomTokenValidatorTest {
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "123456789012345678901234567890ab";
    private static final String SUBJECT = "jleleu";
    private static final String ISSUER = "http://oidcprovider";
    private OidcConfiguration configuration;
    private JwtGenerator generator;
    private Map<String, Object> claims;
    private Nonce nonce;
    private CustomTokenValidator validator;

    @Before
    public void setUp() {
        this.configuration = (OidcConfiguration)Mockito.mock(OidcConfiguration.class);
        OIDCProviderMetadata metadata = (OIDCProviderMetadata)Mockito.mock(OIDCProviderMetadata.class);
        Mockito.when((Object)metadata.getIssuer()).thenReturn((Object)new Issuer(ISSUER));
        Mockito.when((Object)this.configuration.findProviderMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)this.configuration.getClientId()).thenReturn((Object)CLIENT_ID);
        Mockito.when((Object)this.configuration.getSecret()).thenReturn((Object)CLIENT_SECRET);
        Mockito.when((Object)metadata.getIDTokenJWSAlgs()).thenReturn(Arrays.asList(JWSAlgorithm.HS256));
        this.generator = new JwtGenerator((SignatureConfiguration)new SecretSignatureConfiguration(CLIENT_SECRET, JWSAlgorithm.HS256));
        this.claims = new HashMap<String, Object>();
        this.claims.put("iss", ISSUER);
        this.claims.put("sub", SUBJECT);
        this.claims.put("aud", CLIENT_ID);
        long now = new Date().getTime() / 1000L;
        this.claims.put("exp", now + 1000L);
        this.claims.put("iat", now);
        this.nonce = new Nonce();
        this.claims.put("nonce", this.nonce.toString());
        this.validator = new CustomTokenValidator(this.configuration);
    }

    @Test
    public void testRegularValidation() throws Exception {
        String idToken = this.generator.generate(this.claims);
        IDTokenClaimsSet claimsSet = this.validator.validate((JWT)SignedJWT.parse((String)idToken), this.nonce);
        this.checkClaims(claimsSet);
    }

    @Test
    public void testAgentConnectValidation() throws Exception {
        Mockito.when((Object)this.configuration.getCustomParam("acr_values")).thenReturn((Object)"eidas1");
        this.claims.put("acr", "eidas1");
        String idToken = this.generator.generate(this.claims);
        IDTokenClaimsSet claimsSet = this.validator.validate((JWT)SignedJWT.parse((String)idToken), this.nonce);
        this.checkClaims(claimsSet);
    }

    @Test
    public void testAgentConnectValidationFailure() throws Exception {
        Mockito.when((Object)this.configuration.getCustomParam("acr_values")).thenReturn((Object)"eidas1");
        String idToken = this.generator.generate(this.claims);
        try {
            this.validator.validate((JWT)SignedJWT.parse((String)idToken), this.nonce);
            Assert.fail((String)"should fail");
        }
        catch (BadJWTException e) {
            Assert.assertEquals((Object)"[AGENTCONNECT] Bad acr claim in the ID token: it must match the provided value in the acr_values custom param", (Object)e.getMessage());
        }
    }

    private void checkClaims(IDTokenClaimsSet claimsSet) {
        Assert.assertEquals((Object)SUBJECT, (Object)claimsSet.getSubject().toString());
        Assert.assertEquals((Object)ISSUER, (Object)claimsSet.getIssuer().toString());
        Assert.assertEquals((Object)CLIENT_ID, (Object)((Audience)claimsSet.getAudience().get(0)).toString());
        Assert.assertNotNull((Object)claimsSet.getExpirationTime());
        Assert.assertNotNull((Object)claimsSet.getIssueTime());
        Assert.assertEquals((Object)this.nonce, (Object)claimsSet.getNonce());
    }
}

