/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import fr.gouv.vitamui.referential.internal.client.OperationInternalRestClient;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class OperationExternalService
extends AbstractResourceClientService<LogbookOperationDto, LogbookOperationDto> {
    @Autowired
    private OperationInternalRestClient operationInternalRestClient;

    public OperationExternalService(@Autowired ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
    }

    public List<LogbookOperationDto> getAll(Optional<String> criteria) {
        return this.operationInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<LogbookOperationDto, InternalHttpContext> getClient() {
        return this.operationInternalRestClient;
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(element -> (LogbookOperationDto)this.converterToExternalDto((IdDto)element)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public boolean runAudit(AuditOptions auditOptions) {
        return this.operationInternalRestClient.runAudit(this.getInternalHttpContext(), auditOptions);
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public ResponseEntity<Resource> export(String id, ReportType type) {
        return this.operationInternalRestClient.export(this.getInternalHttpContext(), id, type);
    }

    public JsonNode checkTraceabilityOperation(String id) {
        return this.operationInternalRestClient.checkTraceabilityOperation(this.getInternalHttpContext(), id);
    }

    public boolean runProbativeValue(ProbativeValueRequest probativeValueRequest) {
        return this.operationInternalRestClient.runProbativeValue(this.getInternalHttpContext(), probativeValueRequest);
    }

    public ResponseEntity<Resource> exportProbativeValue(String id) {
        return this.operationInternalRestClient.exportProbativeValue(this.getInternalHttpContext(), id);
    }

    @Generated
    public OperationInternalRestClient getOperationInternalRestClient() {
        return this.operationInternalRestClient;
    }

    @Generated
    public void setOperationInternalRestClient(OperationInternalRestClient operationInternalRestClient) {
        this.operationInternalRestClient = operationInternalRestClient;
    }
}

