/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.ManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.internal.client.ManagementContractInternalRestClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagementContractExternalService
extends AbstractResourceClientService<ManagementContractDto, ManagementContractDto> {
    @Autowired
    private ManagementContractInternalRestClient managementContractInternalRestClient;

    public ManagementContractExternalService(@Autowired ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
    }

    public List<ManagementContractDto> getAll(Optional<String> criteria) {
        return this.managementContractInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<ManagementContractDto, InternalHttpContext> getClient() {
        return this.managementContractInternalRestClient;
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public ManagementContractDto getOne(String id) {
        return (ManagementContractDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ManagementContractDto patch(Map<String, Object> partialDto) {
        return (ManagementContractDto)super.patch(partialDto);
    }

    public ManagementContractDto create(ManagementContractDto managementContractDto) {
        return (ManagementContractDto)this.managementContractInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)managementContractDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public PaginatedValuesDto<ManagementContractDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(element -> (ManagementContractDto)this.converterToExternalDto((IdDto)element)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(ManagementContractDto managementContractDto) {
        return this.managementContractInternalRestClient.check(this.getInternalHttpContext(), managementContractDto);
    }

    @Generated
    public ManagementContractInternalRestClient getManagementContractInternalRestClient() {
        return this.managementContractInternalRestClient;
    }

    @Generated
    public void setManagementContractInternalRestClient(ManagementContractInternalRestClient managementContractInternalRestClient) {
        this.managementContractInternalRestClient = managementContractInternalRestClient;
    }
}

