/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.FileFormatDto;
import fr.gouv.vitamui.referential.internal.client.FileFormatInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.FileFormatInternalWebClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileFormatExternalService
extends AbstractResourceClientService<FileFormatDto, FileFormatDto> {
    private FileFormatInternalRestClient fileFormatInternalRestClient;
    private FileFormatInternalWebClient fileFormatInternalWebClient;

    @Autowired
    public FileFormatExternalService(ExternalSecurityService externalSecurityService, FileFormatInternalRestClient fileFormatInternalRestClient, FileFormatInternalWebClient fileFormatInternalWebClient) {
        super(externalSecurityService);
        this.fileFormatInternalRestClient = fileFormatInternalRestClient;
        this.fileFormatInternalWebClient = fileFormatInternalWebClient;
    }

    public List<FileFormatDto> getAll(Optional<String> criteria) {
        return this.fileFormatInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<FileFormatDto, InternalHttpContext> getClient() {
        return this.fileFormatInternalRestClient;
    }

    public PaginatedValuesDto<FileFormatDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(element -> (FileFormatDto)this.converterToExternalDto((IdDto)element)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public FileFormatDto getOne(String id) {
        return (FileFormatDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public FileFormatDto patch(Map<String, Object> partialDto) {
        return (FileFormatDto)super.patch(partialDto);
    }

    public FileFormatDto create(FileFormatDto fileFormatDto) {
        return (FileFormatDto)this.fileFormatInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)fileFormatDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(FileFormatDto accessContractDto) {
        return this.fileFormatInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    public void delete(String id) {
        this.fileFormatInternalRestClient.delete((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ResponseEntity<Resource> export() {
        return this.fileFormatInternalRestClient.export(this.getInternalHttpContext());
    }

    public JsonNode importFileFormats(String fileName, MultipartFile file) {
        return this.fileFormatInternalWebClient.importFileFormats(this.getInternalHttpContext(), fileName, file);
    }
}

