/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.ArchivalProfileUnitDto;
import fr.gouv.vitamui.referential.internal.client.ArchivalProfileInternalWebClient;
import fr.gouv.vitamui.referential.internal.client.ArchivalProfileUnitInternalRestClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArchivalProfileUnitExternalService
extends AbstractResourceClientService<ArchivalProfileUnitDto, ArchivalProfileUnitDto> {
    private ArchivalProfileUnitInternalRestClient archivalProfileUnitInternalRestClient;
    private ArchivalProfileInternalWebClient archivalProfileInternalWebClient;

    @Autowired
    public ArchivalProfileUnitExternalService(ExternalSecurityService externalSecurityService, ArchivalProfileUnitInternalRestClient archivalProfileUnitInternalRestClient, ArchivalProfileInternalWebClient archivalProfileInternalWebClient) {
        super(externalSecurityService);
        this.archivalProfileUnitInternalRestClient = archivalProfileUnitInternalRestClient;
        this.archivalProfileInternalWebClient = archivalProfileInternalWebClient;
    }

    public List<ArchivalProfileUnitDto> getAll(Optional<String> criteria) {
        return this.archivalProfileUnitInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<ArchivalProfileUnitDto, InternalHttpContext> getClient() {
        return this.archivalProfileUnitInternalRestClient;
    }

    public PaginatedValuesDto<ArchivalProfileUnitDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(element -> (ArchivalProfileUnitDto)this.converterToExternalDto((IdDto)element)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public ArchivalProfileUnitDto getOne(String id) {
        return (ArchivalProfileUnitDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ArchivalProfileUnitDto patch(Map<String, Object> partialDto) {
        return (ArchivalProfileUnitDto)super.patch(partialDto);
    }

    public ArchivalProfileUnitDto create(ArchivalProfileUnitDto archivalProfileUnitDto) {
        return (ArchivalProfileUnitDto)this.archivalProfileUnitInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)archivalProfileUnitDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public ArchivalProfileUnitDto update(ArchivalProfileUnitDto dto) {
        return (ArchivalProfileUnitDto)this.archivalProfileUnitInternalRestClient.update((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)dto);
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(ArchivalProfileUnitDto accessContractDto) {
        return this.archivalProfileUnitInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    public void delete(String id) {
        this.archivalProfileUnitInternalRestClient.delete((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ResponseEntity<Resource> export() {
        return this.archivalProfileUnitInternalRestClient.export(this.getInternalHttpContext());
    }

    public ResponseEntity<JsonNode> importArchivalUnitProfiles(String fileName, MultipartFile file) {
        return this.archivalProfileInternalWebClient.importArchivalUnitProfiles(this.getInternalHttpContext(), fileName, file);
    }
}

