/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import fr.gouv.vitamui.referential.internal.client.AgencyInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.AgencyInternalWebClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgencyExternalService
extends AbstractResourceClientService<AgencyDto, AgencyDto> {
    private AgencyInternalRestClient agencyInternalRestClient;
    private AgencyInternalWebClient agencyInternalWebClient;

    @Autowired
    public AgencyExternalService(ExternalSecurityService externalSecurityService, AgencyInternalRestClient agencyInternalRestClient, AgencyInternalWebClient agencyInternalWebClient) {
        super(externalSecurityService);
        this.agencyInternalRestClient = agencyInternalRestClient;
        this.agencyInternalWebClient = agencyInternalWebClient;
    }

    public List<AgencyDto> getAll(Optional<String> criteria) {
        return this.agencyInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    public AgencyDto getOne(String id) {
        return (AgencyDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    protected BasePaginatingAndSortingRestClient<AgencyDto, InternalHttpContext> getClient() {
        return this.agencyInternalRestClient;
    }

    public PaginatedValuesDto<AgencyDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        return this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
    }

    public AgencyDto patch(Map<String, Object> partialDto) {
        return (AgencyDto)super.patch(partialDto);
    }

    public AgencyDto create(AgencyDto accessContractDto) {
        return (AgencyDto)this.agencyInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)accessContractDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(AgencyDto accessContractDto) {
        return this.agencyInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    public boolean deleteAgency(String id) {
        return this.agencyInternalRestClient.deleteAgency(this.getInternalHttpContext(), id);
    }

    public ResponseEntity<Resource> export() {
        return this.agencyInternalRestClient.export(this.getInternalHttpContext());
    }

    public JsonNode importAgencies(String fileName, MultipartFile file) {
        return this.agencyInternalWebClient.importAgencies(this.getInternalHttpContext(), fileName, file);
    }

    @Generated
    public AgencyInternalRestClient getAgencyInternalRestClient() {
        return this.agencyInternalRestClient;
    }

    @Generated
    public AgencyInternalWebClient getAgencyInternalWebClient() {
        return this.agencyInternalWebClient;
    }

    @Generated
    public void setAgencyInternalRestClient(AgencyInternalRestClient agencyInternalRestClient) {
        this.agencyInternalRestClient = agencyInternalRestClient;
    }

    @Generated
    public void setAgencyInternalWebClient(AgencyInternalWebClient agencyInternalWebClient) {
        this.agencyInternalWebClient = agencyInternalWebClient;
    }
}

