/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.AccessContractDto;
import fr.gouv.vitamui.referential.internal.client.AccessContractInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.AccessContractInternalWebClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccessContractExternalService
extends AbstractResourceClientService<AccessContractDto, AccessContractDto> {
    private AccessContractInternalRestClient accessContractInternalRestClient;
    private AccessContractInternalWebClient accessContractInternalWebClient;

    @Autowired
    public AccessContractExternalService(ExternalSecurityService externalSecurityService, AccessContractInternalRestClient accessContractInternalRestClient, AccessContractInternalWebClient accessContractInternalWebClient) {
        super(externalSecurityService);
        this.accessContractInternalRestClient = accessContractInternalRestClient;
        this.accessContractInternalWebClient = accessContractInternalWebClient;
    }

    public List<AccessContractDto> getAll(Optional<String> criteria) {
        return this.accessContractInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    public AccessContractDto patch(Map<String, Object> partialDto) {
        return (AccessContractDto)super.patch(partialDto);
    }

    public AccessContractDto create(AccessContractDto accessContractDto) {
        return (AccessContractDto)this.accessContractInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)accessContractDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name");
    }

    protected BasePaginatingAndSortingRestClient<AccessContractDto, InternalHttpContext> getClient() {
        return this.accessContractInternalRestClient;
    }

    public PaginatedValuesDto<AccessContractDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        return this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
    }

    public AccessContractDto getOne(String id) {
        return (AccessContractDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(AccessContractDto accessContractDto) {
        return this.accessContractInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    public ResponseEntity<Void> importAccessContracts(MultipartFile file) {
        return this.accessContractInternalWebClient.importAccessContracts(this.getInternalHttpContext(), file);
    }

    public ResponseEntity<Resource> exportAccessContracts() {
        return this.accessContractInternalRestClient.exportAccessContracts(this.getInternalHttpContext());
    }

    @Generated
    public AccessContractInternalRestClient getAccessContractInternalRestClient() {
        return this.accessContractInternalRestClient;
    }

    @Generated
    public AccessContractInternalWebClient getAccessContractInternalWebClient() {
        return this.accessContractInternalWebClient;
    }

    @Generated
    public void setAccessContractInternalRestClient(AccessContractInternalRestClient accessContractInternalRestClient) {
        this.accessContractInternalRestClient = accessContractInternalRestClient;
    }

    @Generated
    public void setAccessContractInternalWebClient(AccessContractInternalWebClient accessContractInternalWebClient) {
        this.accessContractInternalWebClient = accessContractInternalWebClient;
    }
}

