/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import fr.gouv.vitamui.referential.external.server.rest.AgencyExternalController;
import fr.gouv.vitamui.referential.external.server.service.OperationExternalService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/operations"})
public class OperationExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AgencyExternalController.class);
    @Autowired
    private OperationExternalService operationExternalService;

    @GetMapping
    @Secured(value={"ROLE_GET_OPERATIONS"})
    public Collection<LogbookOperationDto> getAll(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all audits criteria={}", criteria);
        return this.operationExternalService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_OPERATIONS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.operationExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_OPERATIONS"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException {
        LOGGER.debug("get logbook for audit with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for audit with id :{}", (Object)id);
        return this.operationExternalService.findHistoryById(id);
    }

    @GetMapping(value={"/{id}/download/{type}"})
    public ResponseEntity<Resource> exportEventById(@PathVariable(value="id") String id, @PathVariable(value="type") ReportType type) throws InvalidParseOperationException, PreconditionFailedException {
        EnumUtils.checkValidEnum(ReportType.class, Optional.of(type.name()));
        ParameterChecker.checkParameter((String)"Event Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("export logbook for {} operation with id :{}", (Object)type, (Object)id);
        return this.operationExternalService.export(id, type);
    }

    @Secured(value={"ROLE_RUN_AUDITS"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public boolean create(@Valid @RequestBody AuditOptions auditOptions) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Audit Options is mandatory parameter : ", (Object[])new Object[]{auditOptions});
        SanityChecker.sanitizeCriteria((Object)auditOptions);
        LOGGER.debug("Create {}", (Object)auditOptions);
        return this.operationExternalService.runAudit(auditOptions);
    }

    @PostMapping(value={"/timestamp"})
    public ObjectNode extractInfoFromTimestamp(@RequestBody String timestamp) {
        ObjectNode result = JsonHandler.createObjectNode();
        try {
            ASN1InputStream bIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(Base64.decode((byte[])timestamp.getBytes())));
            ASN1Primitive obj = bIn.readObject();
            TimeStampResponse tsResp = new TimeStampResponse(obj.toASN1Primitive().getEncoded());
            SignerId signerId = tsResp.getTimeStampToken().getSID();
            X500Name signerCertIssuer = signerId.getIssuer();
            result.put("genTime", LocalDateUtil.getString((LocalDateTime)LocalDateUtil.fromDate((Date)tsResp.getTimeStampToken().getTimeStampInfo().getGenTime())));
            result.put("signerCertIssuer", signerCertIssuer.toString());
        }
        catch (IOException | TSPException e) {
            LOGGER.error("Error while transforming timestamp", e);
            throw new BadRequestException("Error while transforming timestamp", e);
        }
        return result;
    }

    @Secured(value={"ROLE_GET_OPERATIONS"})
    @GetMapping(value={"/check/{id}"})
    public JsonNode checkTraceabilityOperation(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Launch check traceability operation with id = {}", (Object)id);
        return this.operationExternalService.checkTraceabilityOperation(id);
    }

    @Secured(value={"ROLE_RUN_PROBATIVE_VALUE"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(value={"/probativeValue"})
    public boolean runProbativeValue(@Valid @RequestBody ProbativeValueRequest probativeValueRequest) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)probativeValueRequest);
        LOGGER.debug("Run {}", (Object)probativeValueRequest);
        return this.operationExternalService.runProbativeValue(probativeValueRequest);
    }

    @Secured(value={"ROLE_RUN_PROBATIVE_VALUE"})
    @GetMapping(value={"/probativeValue/{id}"})
    public ResponseEntity<Resource> exportProbativeValue(@PathVariable(value="id") String operationId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Operation Identifier is mandatory : ", (String[])new String[]{operationId});
        SanityChecker.checkSecureParameter((String[])new String[]{operationId});
        LOGGER.debug("export logbook for operation with id :{}", (Object)operationId);
        return this.operationExternalService.exportProbativeValue(operationId);
    }

    @Generated
    public OperationExternalService getOperationExternalService() {
        return this.operationExternalService;
    }

    @Generated
    public void setOperationExternalService(OperationExternalService operationExternalService) {
        this.operationExternalService = operationExternalService;
    }
}

