/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import fr.gouv.vitamui.referential.external.server.service.OntologyExternalService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/ontology"})
public class OntologyExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyExternalController.class);
    private OntologyExternalService ontologyExternalService;

    @Autowired
    public OntologyExternalController(OntologyExternalService ontologyExternalService) {
        this.ontologyExternalService = ontologyExternalService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_ONTOLOGIES"})
    public Collection<OntologyDto> getAll(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all ontology criteria={}", criteria);
        return this.ontologyExternalService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_ONTOLOGIES"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<OntologyDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.ontologyExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_ONTOLOGIES"})
    @GetMapping(path={"/{identifier:.+}"})
    public OntologyDto getOne(@PathVariable(value="identifier") String identifier) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get ontology identifier={}", (Object)identifier);
        return this.ontologyExternalService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_ONTOLOGIES"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody OntologyDto ontologyDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ontologyDto);
        LOGGER.debug("check exist ontology={}", (Object)ontologyDto);
        boolean exist = this.ontologyExternalService.check(ontologyDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_ONTOLOGIES"})
    public OntologyDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException {
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        SanityChecker.sanitizeCriteria(partialDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.ontologyExternalService.patch(partialDto);
    }

    @Secured(value={"ROLE_CREATE_ONTOLOGIES"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public OntologyDto create(@Valid @RequestBody OntologyDto ontologyDto) throws InvalidParseOperationException {
        SanityChecker.sanitizeCriteria((Object)ontologyDto);
        LOGGER.debug("Create {}", (Object)ontologyDto);
        return this.ontologyExternalService.create(ontologyDto);
    }

    @Secured(value={"ROLE_GET_ONTOLOGIES"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for ontology with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for ontology with id :{}", (Object)id);
        return this.ontologyExternalService.findHistoryById(id);
    }

    @Secured(value={"ROLE_DELETE_ONTOLOGIES"})
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete ontology with id :{}", (Object)id);
        this.ontologyExternalService.delete(id);
    }

    @Secured(value={"ROLE_IMPORT_ONTOLOGIES"})
    @PostMapping(value={"/import"})
    public JsonNode importFileFormats(@RequestParam(value="file") MultipartFile file) {
        if (file != null) {
            SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
            SanityChecker.isValidFileName((String)file.getOriginalFilename());
        }
        LOGGER.debug("Import ontology file {}", (Object)file.getOriginalFilename());
        return this.ontologyExternalService.importOntologies(file.getOriginalFilename(), file);
    }

    @GetMapping(value={"/internal-ontologies"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public List<VitamUiOntologyDto> getInternalOntologiesList() {
        LOGGER.debug("[EXTERNAL] : Get default internal ontology fields list");
        return this.ontologyExternalService.getInternalOntologyList();
    }

    @Generated
    public OntologyExternalService getOntologyExternalService() {
        return this.ontologyExternalService;
    }

    @Generated
    public void setOntologyExternalService(OntologyExternalService ontologyExternalService) {
        this.ontologyExternalService = ontologyExternalService;
    }
}

