/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.external.server.service.ContextExternalService;
import java.util.Collection;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/context"})
public class ContextExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ContextExternalController.class);
    @Autowired
    private ContextExternalService contextExternalService;

    @GetMapping
    @Secured(value={"ROLE_GET_CONTEXTS"})
    public Collection<ContextDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all context criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.contextExternalService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ContextDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        SanityChecker.sanitizeCriteria(criteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.contextExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @GetMapping(path={"/{identifier:.+}"})
    public ContextDto getOne(@PathVariable(value="identifier") String identifier) {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get context identifier={}");
        return this.contextExternalService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@Valid @RequestBody ContextDto contextDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("check exist context = {}", (Object)contextDto);
        SanityChecker.sanitizeCriteria((Object)contextDto);
        ApiUtils.checkValidity((Object)contextDto);
        boolean exist = this.contextExternalService.check(contextDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_CONTEXTS"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public ContextDto create(@Valid @RequestBody ContextDto contextDto) {
        SanityChecker.sanitizeCriteria((Object)contextDto);
        LOGGER.debug("Create {}", (Object)contextDto);
        return this.contextExternalService.create(contextDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_CONTEXTS"})
    public ContextDto patch(@PathVariable(value="id") String id, @RequestBody ContextDto partialDto) {
        SanityChecker.sanitizeCriteria((Object)partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, (Object)partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)partialDto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.contextExternalService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_CONTEXTS"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for context with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        return this.contextExternalService.findHistoryById(id);
    }

    @Generated
    public ContextExternalService getContextExternalService() {
        return this.contextExternalService;
    }

    @Generated
    public void setContextExternalService(ContextExternalService contextExternalService) {
        this.contextExternalService = contextExternalService;
    }
}

