/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.ArchivalProfileUnitDto;
import fr.gouv.vitamui.referential.external.server.service.ArchivalProfileUnitExternalService;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/archival-profile"})
public class ArchivalProfileUnitExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchivalProfileUnitExternalController.class);
    @Autowired
    private ArchivalProfileUnitExternalService archivalProfileUnitExternalService;

    @GetMapping
    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES_UNIT"})
    public Collection<ArchivalProfileUnitDto> getAll(Optional<String> criteria) {
        LOGGER.debug("get all archival unit profiles criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.archivalProfileUnitExternalService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES_UNIT"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ArchivalProfileUnitDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.archivalProfileUnitExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_ARCHIVE_PROFILES_UNIT"})
    @GetMapping(path={"/{identifier:.+}"})
    public ArchivalProfileUnitDto getOne(@PathVariable(value="identifier") String identifier) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("get archival unit profile identifier={}");
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        return this.archivalProfileUnitExternalService.getOne(identifier);
    }

    @Secured(value={"ROLE_CREATE_ARCHIVE_PROFILES_UNIT"})
    @PutMapping(value={"/{id}"})
    public ArchivalProfileUnitDto update(@PathVariable(value="id") String id, @Valid @RequestBody ArchivalProfileUnitDto dto) throws InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update archival unit profile with identifier metadata {} to {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"Unable to update archival unit profile : the DTO id must match the path id");
        return this.archivalProfileUnitExternalService.update(dto);
    }

    @Secured(value={"ROLE_UPDATE_ARCHIVE_PROFILES_UNIT"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public ArchivalProfileUnitDto create(@Valid @RequestBody ArchivalProfileUnitDto archivalProfileUnitDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)archivalProfileUnitDto);
        LOGGER.debug("Create {}", (Object)archivalProfileUnitDto);
        ApiUtils.checkValidity((Object)archivalProfileUnitDto);
        return this.archivalProfileUnitExternalService.create(archivalProfileUnitDto);
    }

    @Secured(value={"ROLE_DELETE_ARCHIVE_PROFILES_UNIT"})
    @PostMapping(value={"/import"})
    public ResponseEntity<JsonNode> importArchivalUnitProfiles(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) throws InvalidParseOperationException {
        LOGGER.debug("Import Archival Unit Profile file {}", (Object)fileName);
        ParameterChecker.checkParameter((String)"The fileName is mandatory parameter :", (String[])new String[]{fileName});
        if (file != null) {
            SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
            SanityChecker.isValidFileName((String)file.getOriginalFilename());
        }
        SanityChecker.checkSecureParameter((String[])new String[]{fileName});
        SanityChecker.isValidFileName((String)fileName);
        SafeFileChecker.checkSafeFilePath((String)fileName);
        return this.archivalProfileUnitExternalService.importArchivalUnitProfiles(fileName, file);
    }

    @Secured(value={"ROLE_GET_PASTIS"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody ArchivalProfileUnitDto archivalProfileUnitDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        ApiUtils.checkValidity((Object)archivalProfileUnitDto);
        SanityChecker.sanitizeCriteria((Object)archivalProfileUnitDto);
        LOGGER.debug("check exist accessContract={}", (Object)archivalProfileUnitDto);
        boolean exist = this.archivalProfileUnitExternalService.check(archivalProfileUnitDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_PASTIS"})
    public ArchivalProfileUnitDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.archivalProfileUnitExternalService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_PASTIS"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        return this.archivalProfileUnitExternalService.findHistoryById(id);
    }

    @Generated
    public ArchivalProfileUnitExternalService getArchivalProfileUnitExternalService() {
        return this.archivalProfileUnitExternalService;
    }

    @Generated
    public void setArchivalProfileUnitExternalService(ArchivalProfileUnitExternalService archivalProfileUnitExternalService) {
        this.archivalProfileUnitExternalService = archivalProfileUnitExternalService;
    }
}

