/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import fr.gouv.vitamui.referential.external.server.service.AgencyExternalService;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/agency"})
public class AgencyExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AgencyExternalController.class);
    public static final String MANDATORY_IDENTIFIER = "Identifier is mandatory : ";
    @Autowired
    private AgencyExternalService agencyExternalService;

    @GetMapping
    @Secured(value={"ROLE_GET_AGENCIES"})
    public Collection<AgencyDto> getAll(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all customer criteria={}", criteria);
        return this.agencyExternalService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_AGENCIES"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<AgencyDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        SanityChecker.sanitizeCriteria(criteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.agencyExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_GET_AGENCIES"})
    @GetMapping(path={"/{identifier:.+}"})
    public AgencyDto getOne(@PathVariable(value="identifier") String identifier) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get agency identifier={}");
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        return this.agencyExternalService.getOne(identifier);
    }

    @Secured(value={"ROLE_GET_AGENCIES"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> check(@RequestBody @Valid AgencyDto agencyDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)agencyDto);
        ApiUtils.checkValidity((Object)agencyDto);
        LOGGER.debug("check exist accessContract={}", (Object)agencyDto);
        boolean exist = this.agencyExternalService.check(agencyDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_CREATE_AGENCIES"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    public AgencyDto create(@Valid @RequestBody AgencyDto agencyDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)agencyDto);
        ApiUtils.checkValidity((Object)agencyDto);
        LOGGER.debug("Create {}", (Object)agencyDto);
        return this.agencyExternalService.create(agencyDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_AGENCIES"})
    public AgencyDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.agencyExternalService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_AGENCIES"})
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        return this.agencyExternalService.findHistoryById(id);
    }

    @Secured(value={"ROLE_DELETE_AGENCIES"})
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Delete agency with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return RestUtils.buildBooleanResponse((boolean)this.agencyExternalService.deleteAgency(id));
    }

    @Secured(value={"ROLE_EXPORT_AGENCIES"})
    @GetMapping(value={"/export"})
    public ResponseEntity<Resource> export() {
        LOGGER.debug("export agencies");
        return this.agencyExternalService.export();
    }

    @Secured(value={"ROLE_IMPORT_AGENCIES"})
    @PostMapping(value={"/import"})
    public JsonNode importAgencies(@RequestParam(value="fileName", required=false) String fileName, @RequestParam(value="file") MultipartFile file) {
        if (file != null) {
            SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
            SanityChecker.isValidFileName((String)file.getOriginalFilename());
        }
        if (Objects.isNull(fileName)) {
            fileName = file.getOriginalFilename();
        }
        SanityChecker.isValidFileName((String)fileName);
        SafeFileChecker.checkSafeFilePath((String)fileName);
        ParameterChecker.checkParameter((String)"The fileName is mandatory parameter : ", (String[])new String[]{fileName});
        LOGGER.debug("Import agency file {}", (Object)fileName);
        return this.agencyExternalService.importAgencies(fileName, file);
    }

    @Generated
    public AgencyExternalService getAgencyExternalService() {
        return this.agencyExternalService;
    }

    @Generated
    public void setAgencyExternalService(AgencyExternalService agencyExternalService) {
        this.agencyExternalService = agencyExternalService;
    }
}

