/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterSummaryDto;
import fr.gouv.vitamui.referential.external.server.service.AccessionRegisterDetailExternalService;
import fr.gouv.vitamui.referential.external.server.service.AccessionRegisterSummaryExternalService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/accession-register"})
public class AccessionRegisterExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessionRegisterExternalController.class);
    private final AccessionRegisterSummaryExternalService accessionRegisterSummaryExternalService;
    private final AccessionRegisterDetailExternalService accessionRegisterDetailExternalService;

    @Autowired
    public AccessionRegisterExternalController(AccessionRegisterSummaryExternalService accessionRegisterSummaryExternalService, AccessionRegisterDetailExternalService accessionRegisterDetailExternalService) {
        this.accessionRegisterSummaryExternalService = accessionRegisterSummaryExternalService;
        this.accessionRegisterDetailExternalService = accessionRegisterDetailExternalService;
    }

    @GetMapping(value={"/summary"})
    @Secured(value={"ROLE_GET_OPERATIONS"})
    public Collection<AccessionRegisterSummaryDto> getAccessionRegisterSummaries(@RequestParam Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all accessionRegister criteria={}", criteria);
        return this.accessionRegisterSummaryExternalService.getAll(criteria);
    }

    @GetMapping(value={"/details"}, params={"page", "size"})
    @Secured(value={"ROLE_GET_ACCESSION_REGISTER_DETAIL"})
    public PaginatedValuesDto<AccessionRegisterDetailDto> getAccessionRegisterDetails(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        SanityChecker.sanitizeCriteria(criteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.accessionRegisterDetailExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @PostMapping(value={"/details/export-csv"})
    @Secured(value={"ROLE_GET_ACCESSION_REGISTER_DETAIL"})
    public Resource exportCsvArchiveUnitsByCriteria(@RequestBody AccessionRegisterSearchDto query) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The query is a mandatory parameter: ", (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.info("Calling export to csv search archive Units By Criteria {} ", (Object)query);
        return this.accessionRegisterDetailExternalService.exportCsvArchiveUnitsByCriteria(query);
    }
}

