/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.pastis.common.dto.profiles.Notice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileResponse;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileType;
import java.io.IOException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoticeUtils.class);

    private NoticeUtils() {
    }

    public static Notice getNoticeFromPUA(JSONObject jsonPUA) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (Notice)((Object)objectMapper.readValue(jsonPUA.toString(), Notice.class));
    }

    public static ProfileResponse convertToProfileResponse(Notice notice) {
        ProfileResponse profileResponse = new ProfileResponse();
        try {
            profileResponse.setId(notice.getId());
            profileResponse.setType(NoticeUtils.getFileType(notice));
            profileResponse.setName(notice.getIdentifier());
            profileResponse.setNotice(NoticeUtils.getNoticeFromPUA(new JSONObject(notice.serialiseString())));
        }
        catch (IOException e) {
            LOGGER.debug("Error while convert notice to profileResponse {}", (Object)notice);
        }
        return profileResponse;
    }

    public static List<String> convert(JSONArray jsonArray) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        List list = (List)objectMapper.readValue(jsonArray.toString(), (TypeReference)new TypeReference<List<String>>(){});
        return list;
    }

    public static ProfileType getFileType(Notice notice) {
        return notice.getPath() != null && notice.getControlSchema() == null ? ProfileType.PA : ProfileType.PUA;
    }
}

