/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.dto.profiles;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileStatus;
import fr.gouv.vitam.common.model.administration.ProfileFormat;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileType;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.CheckForNull;
import lombok.Generated;
import org.springframework.core.io.Resource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Notice
extends IdDto {
    @JsonProperty(value="identifier")
    private String identifier;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="status")
    private ArchiveUnitProfileStatus status;
    @JsonProperty(value="creationDate")
    private String creationDate;
    @JsonProperty(value="lastUpdate")
    private String lastUpdate;
    @JsonProperty(value="activationDate")
    private String activationDate;
    @JsonProperty(value="deactivationDate")
    private String deactivationDate;
    @JsonProperty(value="controlSchema")
    private String controlSchema;
    @JsonProperty(value="tenant")
    private Integer tenant;
    @JsonProperty(value="version")
    private Integer version;
    @JsonProperty(value="fields")
    private List<String> fields;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="format")
    private ProfileFormat format;

    public Notice(Resource resource) throws IOException {
        if (resource == null) {
            return;
        }
        String filename = resource.getFilename();
        if (filename == null) {
            return;
        }
        long updateDate = resource.lastModified();
        long idExample = new SecureRandom().nextLong() / 1000L;
        String id = String.valueOf(Math.abs(idExample));
        String fileBaseName = this.getFileBaseName(filename);
        if (fileBaseName != null) {
            this.identifier = fileBaseName;
        }
        this.setId(id);
        this.status = ArchiveUnitProfileStatus.ACTIVE;
        this.lastUpdate = new Timestamp(updateDate).toString();
        this.deactivationDate = new Timestamp(updateDate).toString();
        this.activationDate = new Timestamp(updateDate).toString();
        this.creationDate = new Timestamp(updateDate).toString();
        this.tenant = 1;
        this.version = 1;
        this.name = fileBaseName;
        if (this.getFileType(filename) == ProfileType.PUA) {
            Notice notice = (Notice)((Object)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(resource.getInputStream(), Notice.class));
            this.controlSchema = notice.controlSchema;
            this.fields = notice.fields;
            this.description = notice.description;
        } else {
            this.path = filename;
            this.format = ProfileFormat.RNG;
        }
    }

    @CheckForNull
    private String getFileBaseName(String fileName) {
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        return tokens[0];
    }

    public ProfileType getFileType(String fileName) {
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        return tokens[1].equals("rng") ? ProfileType.PA : ProfileType.PUA;
    }

    public String serialiseString() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new AfterburnerModule());
        return mapper.writeValueAsString((Object)this);
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ArchiveUnitProfileStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public String getLastUpdate() {
        return this.lastUpdate;
    }

    @Generated
    public String getActivationDate() {
        return this.activationDate;
    }

    @Generated
    public String getDeactivationDate() {
        return this.deactivationDate;
    }

    @Generated
    public String getControlSchema() {
        return this.controlSchema;
    }

    @Generated
    public Integer getTenant() {
        return this.tenant;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public List<String> getFields() {
        return this.fields;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public ProfileFormat getFormat() {
        return this.format;
    }

    @JsonProperty(value="identifier")
    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="status")
    @Generated
    public void setStatus(ArchiveUnitProfileStatus status) {
        this.status = status;
    }

    @JsonProperty(value="creationDate")
    @Generated
    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @JsonProperty(value="lastUpdate")
    @Generated
    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @JsonProperty(value="activationDate")
    @Generated
    public void setActivationDate(String activationDate) {
        this.activationDate = activationDate;
    }

    @JsonProperty(value="deactivationDate")
    @Generated
    public void setDeactivationDate(String deactivationDate) {
        this.deactivationDate = deactivationDate;
    }

    @JsonProperty(value="controlSchema")
    @Generated
    public void setControlSchema(String controlSchema) {
        this.controlSchema = controlSchema;
    }

    @JsonProperty(value="tenant")
    @Generated
    public void setTenant(Integer tenant) {
        this.tenant = tenant;
    }

    @JsonProperty(value="version")
    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="fields")
    @Generated
    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="format")
    @Generated
    public void setFormat(ProfileFormat format) {
        this.format = format;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Notice)) {
            return false;
        }
        Notice other = (Notice)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$tenant = this.getTenant();
        Integer other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !((Object)this$tenant).equals(other$tenant)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ArchiveUnitProfileStatus this$status = this.getStatus();
        ArchiveUnitProfileStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$creationDate = this.getCreationDate();
        String other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !this$creationDate.equals(other$creationDate)) {
            return false;
        }
        String this$lastUpdate = this.getLastUpdate();
        String other$lastUpdate = other.getLastUpdate();
        if (this$lastUpdate == null ? other$lastUpdate != null : !this$lastUpdate.equals(other$lastUpdate)) {
            return false;
        }
        String this$activationDate = this.getActivationDate();
        String other$activationDate = other.getActivationDate();
        if (this$activationDate == null ? other$activationDate != null : !this$activationDate.equals(other$activationDate)) {
            return false;
        }
        String this$deactivationDate = this.getDeactivationDate();
        String other$deactivationDate = other.getDeactivationDate();
        if (this$deactivationDate == null ? other$deactivationDate != null : !this$deactivationDate.equals(other$deactivationDate)) {
            return false;
        }
        String this$controlSchema = this.getControlSchema();
        String other$controlSchema = other.getControlSchema();
        if (this$controlSchema == null ? other$controlSchema != null : !this$controlSchema.equals(other$controlSchema)) {
            return false;
        }
        List<String> this$fields = this.getFields();
        List<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        ProfileFormat this$format = this.getFormat();
        ProfileFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Notice;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : ((Object)$tenant).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ArchiveUnitProfileStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : $creationDate.hashCode());
        String $lastUpdate = this.getLastUpdate();
        result = result * 59 + ($lastUpdate == null ? 43 : $lastUpdate.hashCode());
        String $activationDate = this.getActivationDate();
        result = result * 59 + ($activationDate == null ? 43 : $activationDate.hashCode());
        String $deactivationDate = this.getDeactivationDate();
        result = result * 59 + ($deactivationDate == null ? 43 : $deactivationDate.hashCode());
        String $controlSchema = this.getControlSchema();
        result = result * 59 + ($controlSchema == null ? 43 : $controlSchema.hashCode());
        List<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        ProfileFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Notice(identifier=" + this.getIdentifier() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ", creationDate=" + this.getCreationDate() + ", lastUpdate=" + this.getLastUpdate() + ", activationDate=" + this.getActivationDate() + ", deactivationDate=" + this.getDeactivationDate() + ", controlSchema=" + this.getControlSchema() + ", tenant=" + this.getTenant() + ", version=" + this.getVersion() + ", fields=" + this.getFields() + ", path=" + this.getPath() + ", format=" + this.getFormat() + ")";
    }

    @Generated
    public Notice(String identifier, String name, String description, ArchiveUnitProfileStatus status, String creationDate, String lastUpdate, String activationDate, String deactivationDate, String controlSchema, Integer tenant, Integer version, List<String> fields, String path, ProfileFormat format) {
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.status = status;
        this.creationDate = creationDate;
        this.lastUpdate = lastUpdate;
        this.activationDate = activationDate;
        this.deactivationDate = deactivationDate;
        this.controlSchema = controlSchema;
        this.tenant = tenant;
        this.version = version;
        this.fields = fields;
        this.path = path;
        this.format = format;
    }

    @Generated
    public Notice() {
    }
}

