/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.external.server.service;

import fr.gouv.archive.internal.client.ArchiveInternalRestClient;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.internal.client.ExternalParametersInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchThresholdService
extends AbstractResourceClientService<ArchiveUnitsDto, ArchiveUnitsDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchThresholdService.class);
    public static final String PARAM_BULK_OPERATIONS_THRESHOLD_NAME = "PARAM_BULK_OPERATIONS_THRESHOLD";
    @Autowired
    private final ExternalParametersInternalRestClient externalParametersInternalRestClient;
    @Autowired
    private final ArchiveInternalRestClient archiveInternalRestClient;

    public ArchiveSearchThresholdService(@Autowired ArchiveInternalRestClient archiveInternalRestClient, ExternalSecurityService externalSecurityService, ExternalParametersInternalRestClient externalParametersInternalRestClient) {
        super(externalSecurityService);
        this.archiveInternalRestClient = archiveInternalRestClient;
        this.externalParametersInternalRestClient = externalParametersInternalRestClient;
    }

    protected ArchiveInternalRestClient getClient() {
        return this.archiveInternalRestClient;
    }

    public Optional<Long> retrieveProfilThresholds() {
        ParameterDto parameterThreshold;
        Optional<Long> thresholdOpt = Optional.empty();
        ExternalParametersDto myExternalParameter = this.externalParametersInternalRestClient.getMyExternalParameters(this.getInternalHttpContext());
        if (myExternalParameter != null && !CollectionUtils.isEmpty((Collection)myExternalParameter.getParameters()) && (parameterThreshold = (ParameterDto)myExternalParameter.getParameters().stream().filter(parameter -> PARAM_BULK_OPERATIONS_THRESHOLD_NAME.equals(parameter.getKey())).findFirst().orElse(null)) != null && parameterThreshold.getValue() != null) {
            try {
                Long thresholdValue = Long.valueOf(parameterThreshold.getValue());
                thresholdOpt = Optional.of(thresholdValue);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("external parameter of bulk threshold contains wrong integer value {}, it will not be used ", (Object)parameterThreshold.getValue());
                throw new IllegalArgumentException("external parameter of bulk threshold contains wrong integer value " + parameterThreshold.getValue() + ", it will not be used ");
            }
        }
        return thresholdOpt;
    }
}

