/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.common.utils;

import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class IdentityProviderHelper {
    public Optional<IdentityProviderDto> findByTechnicalName(List<IdentityProviderDto> providers, String name) {
        for (IdentityProviderDto provider : providers) {
            if (!StringUtils.equals((String)provider.getTechnicalName(), (String)name)) continue;
            return Optional.of(provider);
        }
        return Optional.empty();
    }

    public List<IdentityProviderDto> findAllProvidersByUserIdentifier(List<IdentityProviderDto> providers, String identifier) {
        return providers.stream().filter(provider -> provider.getPatterns().stream().anyMatch(pattern -> Pattern.compile(pattern, 2).matcher(identifier).matches())).collect(Collectors.toList());
    }

    public Optional<IdentityProviderDto> findByUserIdentifierAndCustomerId(List<IdentityProviderDto> providers, String userIdentifier, String customerId) {
        if (CollectionUtils.isEmpty(providers)) {
            return Optional.empty();
        }
        return providers.stream().filter(provider -> provider.getCustomerId().equals(customerId)).filter(provider -> provider.getPatterns().stream().anyMatch(pattern -> Pattern.compile(pattern, 2).matcher(userIdentifier).matches())).findFirst();
    }

    public boolean identifierMatchProviderPattern(List<IdentityProviderDto> providers, String userEmail, String userCustomerId) {
        Optional<IdentityProviderDto> optProvider = this.findByUserIdentifierAndCustomerId(providers, userEmail, userCustomerId);
        return optProvider.isPresent() && optProvider.get().getInternal() == Boolean.TRUE;
    }
}

