/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import java.util.Collections;
import java.util.Optional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class UnitExternalRestClient
extends BaseRestClient<ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UnitExternalRestClient.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    public UnitExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String getPathUrl() {
        return "/units";
    }

    protected Class<JsonNode> getJsonNodeClass() {
        return JsonNode.class;
    }

    public VitamUISearchResponseDto findUnitById(ExternalHttpContext context, String unitId) {
        VitamUISearchResponseDto result;
        MultiValueMap<String, String> headers = this.buildSearchHeaders(context);
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + unitId, HttpMethod.GET, request, this.getJsonNodeClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        try {
            result = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)response.getBody(), VitamUISearchResponseDto.class);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
        return result;
    }

    public JsonNode findUnitByDsl(ExternalHttpContext context, Optional<String> id, JsonNode dsl) {
        MultiValueMap<String, String> headers = this.buildSearchHeaders(context);
        HttpEntity request = new HttpEntity((Object)dsl, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/dsl" + (String)(id.isPresent() ? "/" + id.get() : ""), HttpMethod.POST, request, this.getJsonNodeClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (JsonNode)response.getBody();
    }

    public JsonNode findObjectMetadataById(ExternalHttpContext context, String id, JsonNode dsl) {
        MultiValueMap<String, String> headers = this.buildSearchHeaders(context);
        HttpEntity request = new HttpEntity((Object)dsl, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + id + "/objects", HttpMethod.POST, request, this.getJsonNodeClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (JsonNode)response.getBody();
    }

    public VitamUISearchResponseDto getFilingAndHoldingUnits(ExternalHttpContext context) {
        LOGGER.debug("Calling get filing plan and holding units");
        MultiValueMap<String, String> headers = this.buildSearchHeaders(context);
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/filingplan", HttpMethod.GET, request, VitamUISearchResponseDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (VitamUISearchResponseDto)response.getBody();
    }

    private MultiValueMap<String, String> buildSearchHeaders(ExternalHttpContext context) {
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        String accessContract = null;
        if (context instanceof ExternalHttpContext) {
            ExternalHttpContext externalCallContext = context;
            accessContract = externalCallContext.getAccessContract();
        }
        if (accessContract != null) {
            headers.put((Object)"X-Access-Contract-Id", Collections.singletonList(accessContract));
        }
        return headers;
    }
}

