/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchInternalService;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.TransferAcknowledgmentService;
import fr.gouv.vitamui.commons.vitam.api.access.TransferRequestService;
import java.io.InputStream;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class TransferVitamOperationsInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TransferVitamOperationsInternalService.class);
    public static final String OPERATION_IDENTIFIER = "itemId";
    private final TransferAcknowledgmentService transferAcknowledgmentService;
    private final TransferRequestService transferRequestService;
    private final ArchiveSearchInternalService archiveSearchInternalService;

    public TransferVitamOperationsInternalService(TransferAcknowledgmentService transferAcknowledgmentService, @Lazy ArchiveSearchInternalService archiveSearchInternalService, TransferRequestService transferRequestService) {
        this.transferAcknowledgmentService = transferAcknowledgmentService;
        this.archiveSearchInternalService = archiveSearchInternalService;
        this.transferRequestService = transferRequestService;
    }

    private JsonNode sendTransferRequest(VitamContext vitamContext, TransferRequest transferRequest) throws VitamClientException {
        RequestResponse response = this.transferRequestService.transferRequest(vitamContext, transferRequest);
        return response.toJsonNode();
    }

    private TransferRequest prepareTransferRequestBody(TransferRequestDto transferRequestDto, JsonNode dslQuery) {
        TransferRequest transferRequest = new TransferRequest();
        if (transferRequestDto != null) {
            DataObjectVersions dataObjectVersions = new DataObjectVersions();
            dataObjectVersions.setDataObjectVersionsPatterns(transferRequestDto.getDataObjectVersionsPatterns());
            transferRequest.setTransferWithLogBookLFC(transferRequestDto.isLifeCycleLogs());
            transferRequest.setTransferWithoutObjects(transferRequestDto.isWithoutObjects());
            transferRequest.setDslRequest(dslQuery);
            transferRequest.setDataObjectVersionToExport(dataObjectVersions);
            transferRequest.setTransferRequestParameters(transferRequestDto.getTransferRequestParameters());
            transferRequest.setSedaVersion(transferRequestDto.getSedaVersion());
        }
        return transferRequest;
    }

    public String transferRequest(TransferRequestDto transferRequestDto, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Transfer request: {} ", (Object)transferRequestDto.toString());
        JsonNode dslQuery = this.archiveSearchInternalService.prepareDslQuery(transferRequestDto.getSearchCriteria(), vitamContext);
        LOGGER.debug("Transfer request final DSL query: {} ", (Object)dslQuery);
        TransferRequest transferRequest = this.prepareTransferRequestBody(transferRequestDto, dslQuery);
        JsonNode response = this.sendTransferRequest(vitamContext, transferRequest);
        return response.findValue(OPERATION_IDENTIFIER).textValue();
    }

    public String transferAcknowledgmentService(InputStream atrInputStream, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Transfer Acknowledgment Operation");
        JsonNode transferAcknowledgmentResponse = this.transferAcknowledgmentService.transferAcknowledgment(vitamContext, atrInputStream).toJsonNode();
        return transferAcknowledgmentResponse.findValue(OPERATION_IDENTIFIER).textValue();
    }
}

