/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.export.dip.DipExportType;
import fr.gouv.vitam.common.model.export.dip.DipRequest;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchInternalService;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.ExportDipV2Service;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ExportDipInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExportDipInternalService.class);
    public static final String OPERATION_IDENTIFIER = "itemId";
    private final ExportDipV2Service exportDipV2Service;
    private final ArchiveSearchInternalService archiveSearchInternalService;

    public ExportDipInternalService(@Lazy ArchiveSearchInternalService archiveSearchInternalService, ExportDipV2Service exportDipV2Service) {
        this.archiveSearchInternalService = archiveSearchInternalService;
        this.exportDipV2Service = exportDipV2Service;
    }

    private JsonNode exportDIP(VitamContext vitamContext, DipRequest dipRequest) throws VitamClientException {
        RequestResponse response = this.exportDipV2Service.exportDip(vitamContext, dipRequest);
        return response.toJsonNode();
    }

    private DipRequest prepareDipRequestBody(ExportDipCriteriaDto exportDipCriteriaDto, JsonNode dslQuery) {
        DipRequest dipRequest = new DipRequest();
        if (exportDipCriteriaDto != null) {
            DataObjectVersions dataObjectVersionToExport = new DataObjectVersions();
            dataObjectVersionToExport.setDataObjectVersionsPatterns(exportDipCriteriaDto.getDataObjectVersionsPatterns());
            dipRequest.setExportWithLogBookLFC(exportDipCriteriaDto.isLifeCycleLogs());
            dipRequest.setExportWithoutObjects(exportDipCriteriaDto.isWithoutObjects());
            dipRequest.setDslRequest(dslQuery);
            dipRequest.setDipExportType(DipExportType.FULL);
            dipRequest.setDataObjectVersionToExport(dataObjectVersionToExport);
            dipRequest.setDipRequestParameters(exportDipCriteriaDto.getDipRequestParameters());
            dipRequest.setSedaVersion(exportDipCriteriaDto.getSedaVersion());
        }
        return dipRequest;
    }

    public String requestToExportDIP(ExportDipCriteriaDto exportDipCriteriaDto, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Export DIP by criteria {} ", (Object)exportDipCriteriaDto.toString());
        JsonNode dslQuery = this.archiveSearchInternalService.prepareDslQuery(exportDipCriteriaDto.getExportDIPSearchCriteria(), vitamContext);
        LOGGER.debug("Export DIP final DSL query {} ", (Object)dslQuery);
        DipRequest dipRequest = this.prepareDipRequestBody(exportDipCriteriaDto, dslQuery);
        JsonNode response = this.exportDIP(vitamContext, dipRequest);
        return response.findValue(OPERATION_IDENTIFIER).textValue();
    }
}

