/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchAgenciesInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchFacetsInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchRulesInternalService;
import fr.gouv.vitamui.archives.search.common.common.RulesUpdateCommonService;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedSettingsException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.MetadataSearchCriteriaUtils;
import fr.gouv.vitamui.commons.api.utils.OntologyServiceReader;
import fr.gouv.vitamui.commons.vitam.api.access.PersistentIdentifierService;
import fr.gouv.vitamui.commons.vitam.api.access.UnitService;
import fr.gouv.vitamui.commons.vitam.api.dto.PersistentIdentifierResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.commons.vitam.api.model.UnitTypeEnum;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchInternalService.class);
    private static final String ARCHIVE_UNIT_DETAILS = "$results";
    private static final String HISTORY = "$history";
    public static final String DSL_QUERY_PROJECTION = "$projection";
    public static final String DSL_QUERY_FILTER = "$filter";
    public static final String DSL_QUERY_THRESHOLD = "$threshold";
    public static final String DSL_QUERY_FACETS = "$facets";
    public static final String OPERATION_IDENTIFIER = "itemId";
    public static final String TITLE_FIELD = "Title";
    private static final Integer SEARCH_UNIT_MAX_RESULTS = 10000;
    private static final String[] FILING_PLAN_PROJECTION = new String[]{"#id", "Title", "Title_", "DescriptionLevel", "#unitType", "#unitups", "#allunitups", "#object"};
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    private static final String SET = "$set";
    private static final String UNSET = "$unset";
    private static final String ACTION = "$action";
    @Value(value="${ontologies_file_path}")
    private String ontologiesFilePath;
    private final ObjectMapper objectMapper;
    private final UnitService unitService;
    private final ArchiveSearchAgenciesInternalService archiveSearchAgenciesInternalService;
    private final ArchiveSearchRulesInternalService archiveSearchRulesInternalService;
    private final ArchiveSearchFacetsInternalService archiveSearchFacetsInternalService;
    private final PersistentIdentifierService persistentIdentifierService;

    @Autowired
    public ArchiveSearchInternalService(ObjectMapper objectMapper, UnitService unitService, ArchiveSearchAgenciesInternalService archiveSearchAgenciesInternalService, ArchiveSearchRulesInternalService archiveSearchRulesInternalService, ArchiveSearchFacetsInternalService archiveSearchFacetsInternalService, PersistentIdentifierService persistentIdentifierService) {
        this.unitService = unitService;
        this.objectMapper = objectMapper;
        this.archiveSearchAgenciesInternalService = archiveSearchAgenciesInternalService;
        this.archiveSearchRulesInternalService = archiveSearchRulesInternalService;
        this.archiveSearchFacetsInternalService = archiveSearchFacetsInternalService;
        this.persistentIdentifierService = persistentIdentifierService;
    }

    public ArchiveUnitsDto searchArchiveUnitsByCriteria(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException, IOException {
        try {
            LOGGER.debug("calling find archive units by criteria {} ", (Object)searchQuery.toString());
            this.archiveSearchAgenciesInternalService.mapAgenciesNameToCodes(searchQuery, vitamContext);
            this.archiveSearchRulesInternalService.mapManagementRulesTitlesToCodes(searchQuery, vitamContext);
            ObjectNode dslQuery = MetadataSearchCriteriaUtils.createDslQueryWithFacets((SearchCriteriaDto)searchQuery).getFinalSelect();
            JsonNode vitamResponse = this.searchArchiveUnits((JsonNode)dslQuery, vitamContext);
            ArchiveUnitsDto archiveUnitsDto = this.decorateAndMapResponse(vitamResponse, vitamContext);
            Integer totalResults = archiveUnitsDto.getArchives().getHits().getTotal();
            boolean trackTotalHits = totalResults >= SEARCH_UNIT_MAX_RESULTS;
            this.fillManagementRulesFacets(searchQuery, archiveUnitsDto, trackTotalHits, vitamContext);
            return archiveUnitsDto;
        }
        catch (InvalidCreateOperationException ioe) {
            throw new VitamClientException("Unable to find archive units with pagination", (Throwable)ioe);
        }
    }

    private void fillManagementRulesFacets(SearchCriteriaDto searchQuery, ArchiveUnitsDto archiveUnitsDto, boolean trackTotalHits, VitamContext vitamContext) throws InvalidCreateOperationException, VitamClientException, JsonProcessingException {
        try {
            archiveUnitsDto.getArchives().getFacetResults().addAll(this.archiveSearchFacetsInternalService.fillManagementRulesFacets(searchQuery, trackTotalHits, vitamContext));
        }
        catch (UnexpectedSettingsException e) {
            if (!searchQuery.isComputeFacets()) {
                LOGGER.error("Could not compute facets,the setting track total hits is not allowed in vitam, we return units without facets");
            }
            LOGGER.error("Could not compute facets,the setting track total hits is not allowed in vitam, ");
            throw new UnexpectedSettingsException(e.getMessage());
        }
    }

    private ArchiveUnitsDto decorateAndMapResponse(JsonNode vitamResponse, VitamContext vitamContext) throws JsonProcessingException, VitamClientException {
        VitamUISearchResponseDto archivesOriginResponse = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)vitamResponse, VitamUISearchResponseDto.class);
        Set<String> originatingAgenciesCodes = archivesOriginResponse.getResults().stream().map(ResultsDto::getOriginatingAgency).filter(Objects::nonNull).collect(Collectors.toSet());
        List<AgencyModelDto> originAgenciesFound = this.archiveSearchAgenciesInternalService.findOriginAgenciesByCodes(vitamContext, originatingAgenciesCodes);
        Map<String, AgencyModelDto> agenciesMapByIdentifier = originAgenciesFound.stream().collect(Collectors.toMap(AgencyModelDto::getIdentifier, agency -> agency));
        List archivesFilled = archivesOriginResponse.getResults().stream().map(archiveUnit -> RulesUpdateCommonService.fillOriginatingAgencyName((ResultsDto)archiveUnit, (Map)agenciesMapByIdentifier)).collect(Collectors.toList());
        VitamUIArchiveUnitResponseDto responseFilled = new VitamUIArchiveUnitResponseDto();
        responseFilled.setContext(archivesOriginResponse.getContext());
        responseFilled.setFacetResults(archivesOriginResponse.getFacetResults());
        responseFilled.setResults(archivesFilled);
        responseFilled.setHits(archivesOriginResponse.getHits());
        return new ArchiveUnitsDto(responseFilled);
    }

    public JsonNode mapRequestToDslQuery(SearchCriteriaDto searchQuery) throws VitamClientException {
        SelectMultiQuery selectMultiQuery = MetadataSearchCriteriaUtils.mapRequestToSelectMultiQuery((SearchCriteriaDto)searchQuery);
        return selectMultiQuery.getFinalSelect();
    }

    public JsonNode searchArchiveUnits(JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        RequestResponse response = this.unitService.searchUnits(dslQuery, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode getFillingHoldingScheme(VitamContext vitamContext) throws VitamClientException {
        JsonNode fillingHoldingQuery = this.createQueryForHoldingFillingUnit();
        return this.searchArchiveUnits(fillingHoldingQuery, vitamContext);
    }

    public ResultsDto findArchiveUnitById(String id, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.debug("Archive Unit Id : {}", (Object)id);
            String re = StringUtils.chop((String)this.unitService.findUnitById(id, vitamContext).toJsonNode().get(ARCHIVE_UNIT_DETAILS).toString().substring(1));
            return (ResultsDto)this.objectMapper.readValue(re, ResultsDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Can not get the archive unit {} ", (Throwable)e);
            throw new VitamClientException("Unable to find the UA", (Throwable)e);
        }
    }

    public ResultsDto findObjectById(String id, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.debug("Get Object Group");
            String re = StringUtils.chop((String)this.unitService.findObjectMetadataById(id, vitamContext).toJsonNode().get(ARCHIVE_UNIT_DETAILS).toString().substring(1));
            LOGGER.debug("Object received: {}" + re);
            return (ResultsDto)this.objectMapper.readValue(re, ResultsDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Can not get the object group {} ", (Throwable)e);
            throw new InternalServerException("Unable to find the ObjectGroup", (Throwable)e);
        }
    }

    public Response downloadObjectFromUnit(String id, String usage, Integer version, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Download Archive Unit Object with id {} , usage {} and version {}  ", new Object[]{id, usage, version});
        return this.unitService.getObjectStreamByUnitId(id, usage, version.intValue(), vitamContext);
    }

    public JsonNode prepareDslQuery(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        searchQuery.setPageNumber(Integer.valueOf(0));
        this.archiveSearchAgenciesInternalService.mapAgenciesNameToCodes(searchQuery, vitamContext);
        this.archiveSearchRulesInternalService.mapManagementRulesTitlesToCodes(searchQuery, vitamContext);
        return this.mapRequestToDslQuery(searchQuery);
    }

    public JsonNode createQueryForHoldingFillingUnit() {
        try {
            SelectMultiQuery select = new SelectMultiQuery();
            InQuery query = QueryHelper.in((String)VitamFieldsHelper.unitType(), (String[])new String[]{UnitTypeEnum.HOLDING_UNIT.getValue(), UnitTypeEnum.FILING_UNIT.getValue()});
            select.addQueries(new Query[]{query});
            ObjectNode orderFilter = JsonHandler.createObjectNode();
            orderFilter.put(TITLE_FIELD, 1);
            ObjectNode filter = JsonHandler.createObjectNode();
            filter.set("$orderby", (JsonNode)orderFilter);
            select.setFilter((JsonNode)filter);
            select.addUsedProjection(FILING_PLAN_PROJECTION);
            LOGGER.debug("query =", (Object)select.getFinalSelect().toPrettyString());
            return select.getFinalSelect();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new UnexpectedDataException("Unexpected error occured while building holding dsl query : " + e.getMessage());
        }
    }

    public String computedInheritedRules(SearchCriteriaDto searchCriteriaDto, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Computed Inherited Rules by criteria {} ", (Object)searchCriteriaDto.toString());
        JsonNode jsonNode = this.mapRequestToDslQuery(searchCriteriaDto);
        ObjectNode dslRequest = (ObjectNode)jsonNode;
        RulesUpdateCommonService.deleteAttributesFromObjectNode((ObjectNode)dslRequest, (String[])new String[]{DSL_QUERY_PROJECTION, DSL_QUERY_FILTER, DSL_QUERY_FACETS});
        LOGGER.debug("Computed Inherited Rules final dslQuery : {}", (Object)dslRequest);
        JsonNode response = this.computedInheritedRules(vitamContext, (JsonNode)dslRequest);
        return response.findValue(OPERATION_IDENTIFIER).textValue();
    }

    private JsonNode computedInheritedRules(VitamContext vitamContext, JsonNode dslQuery) throws VitamClientException {
        RequestResponse response = this.unitService.computedInheritedRules(vitamContext, dslQuery);
        return response.toJsonNode();
    }

    public JsonNode selectUnitWithInheritedRules(JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        RequestResponse response = this.unitService.selectUnitsWithInheritedRules(vitamContext, dslQuery);
        return response.toJsonNode();
    }

    public ResultsDto selectUnitWithInheritedRules(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException, IOException {
        ResultsDto response = new ResultsDto();
        LOGGER.debug("calling select Units With Inherited Rules by criteria {} ", (Object)searchQuery.toString());
        this.archiveSearchAgenciesInternalService.mapAgenciesNameToCodes(searchQuery, vitamContext);
        JsonNode dslQuery = this.mapRequestToDslQuery(searchQuery);
        RulesUpdateCommonService.deleteAttributesFromObjectNode((ObjectNode)((ObjectNode)dslQuery), (String[])new String[]{DSL_QUERY_FACETS});
        JsonNode vitamResponse = this.selectUnitWithInheritedRules(dslQuery, vitamContext);
        ArchiveUnitsDto archiveUnitsDto = this.decorateAndMapResponse(vitamResponse, vitamContext);
        if (Objects.nonNull(archiveUnitsDto.getArchives()) && !CollectionUtils.isEmpty((Collection)archiveUnitsDto.getArchives().getResults())) {
            response = (ResultsDto)archiveUnitsDto.getArchives().getResults().get(0);
        }
        return response;
    }

    public String reclassification(ReclassificationCriteriaDto reclassificationCriteriaDto, VitamContext vitamContext) throws VitamClientException {
        if (reclassificationCriteriaDto == null) {
            throw new BadRequestException("Error reclassification criteria");
        }
        LOGGER.debug("Reclassification Object : {}", (Object)reclassificationCriteriaDto.toString());
        JsonNode dslQuery = this.mapRequestToDslQuery(reclassificationCriteriaDto.getSearchCriteriaDto());
        ArrayNode array = JsonHandler.createArrayNode();
        ((ObjectNode)dslQuery).putPOJO(ACTION, (Object)reclassificationCriteriaDto.getAction());
        Arrays.stream(new String[]{DSL_QUERY_PROJECTION, DSL_QUERY_FILTER, DSL_QUERY_FACETS, DSL_QUERY_THRESHOLD}).forEach(arg_0 -> ((ObjectNode)((ObjectNode)dslQuery)).remove(arg_0));
        array.add(dslQuery);
        LOGGER.debug("Reclassification query : {}", (Object)array);
        RequestResponse jsonNodeRequestResponse = this.unitService.reclassification(vitamContext, (JsonNode)array);
        return jsonNodeRequestResponse.toJsonNode().findValue(OPERATION_IDENTIFIER).textValue();
    }

    public List<VitamUiOntologyDto> readExternalOntologiesFromFile(Integer tenantId) throws IOException {
        LOGGER.debug("get ontologies file from path : {} ", (Object)this.ontologiesFilePath);
        return OntologyServiceReader.readExternalOntologiesFromFile((Integer)tenantId, (String)this.ontologiesFilePath);
    }

    public PersistentIdentifierResponseDto findUnitsByPersistentIdentifier(String identifier, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Persistent identifier : {}", (Object)identifier);
        RequestResponse response = this.persistentIdentifierService.findUnitsByPersistentIdentifier(identifier, vitamContext);
        try {
            return (PersistentIdentifierResponseDto)this.objectMapper.readValue(response.toString(), PersistentIdentifierResponseDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Response not in good format {}", (Throwable)e);
            throw new VitamClientException("Unable to find the UA", (Throwable)e);
        }
    }

    public PersistentIdentifierResponseDto findObjectsByPersistentIdentifier(String identifier, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Persistent identifier : {}", (Object)identifier);
        RequestResponse response = this.persistentIdentifierService.findObjectsByPersistentIdentifier(identifier, vitamContext);
        try {
            return (PersistentIdentifierResponseDto)this.objectMapper.readValue(response.toString(), PersistentIdentifierResponseDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Response not in good format {}", (Throwable)e);
            throw new VitamClientException("Unable to find the GOT", (Throwable)e);
        }
    }

    @Generated
    public String getOntologiesFilePath() {
        return this.ontologiesFilePath;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public UnitService getUnitService() {
        return this.unitService;
    }

    @Generated
    public ArchiveSearchAgenciesInternalService getArchiveSearchAgenciesInternalService() {
        return this.archiveSearchAgenciesInternalService;
    }

    @Generated
    public ArchiveSearchRulesInternalService getArchiveSearchRulesInternalService() {
        return this.archiveSearchRulesInternalService;
    }

    @Generated
    public ArchiveSearchFacetsInternalService getArchiveSearchFacetsInternalService() {
        return this.archiveSearchFacetsInternalService;
    }

    @Generated
    public PersistentIdentifierService getPersistentIdentifierService() {
        return this.persistentIdentifierService;
    }
}

