/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.searchcriteria.service;

import fr.gouv.vitamui.archive.internal.server.searchcriteria.converter.SearchCriteriaHistoryConverter;
import fr.gouv.vitamui.archive.internal.server.searchcriteria.dao.SearchCriteriaHistoryRepository;
import fr.gouv.vitamui.archive.internal.server.searchcriteria.domain.SearchCriteriaHistory;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaHistoryDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.mongo.dao.CustomSequenceRepository;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class SearchCriteriaHistoryInternalService
extends VitamUICrudService<SearchCriteriaHistoryDto, SearchCriteriaHistory> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SearchCriteriaHistoryInternalService.class);
    private final SearchCriteriaHistoryRepository searchCriteriaHistoryRepo;
    private final SearchCriteriaHistoryConverter searchCriteriaHistoryConverter;
    private final InternalSecurityService internalSecurityService;

    @Autowired
    public SearchCriteriaHistoryInternalService(CustomSequenceRepository sequenceRepository, SearchCriteriaHistoryRepository searchCriteriaHistoryRepo, SearchCriteriaHistoryConverter searchCriteriaHistoryConverter, InternalSecurityService internalSecurityService) {
        super(sequenceRepository);
        this.searchCriteriaHistoryRepo = searchCriteriaHistoryRepo;
        this.searchCriteriaHistoryConverter = searchCriteriaHistoryConverter;
        this.internalSecurityService = internalSecurityService;
    }

    public List<SearchCriteriaHistoryDto> getSearchCriteriaHistoryDtos() {
        LOGGER.debug("getSearchCriteriaHistoryDtos");
        AuthUserDto authUserDto = this.internalSecurityService.getUser();
        LOGGER.debug("Get the search history for user : {}", (Object)authUserDto.getIdentifier());
        QueryDto criteria = new QueryDto();
        criteria.addCriterion(new Criterion("userId", (Object)authUserDto.getIdentifier(), CriterionOperator.EQUALS));
        return this.getAll(criteria);
    }

    protected void beforeCreate(SearchCriteriaHistoryDto dto) {
        AuthUserDto authUserDto = this.internalSecurityService.getUser();
        dto.setUserId(authUserDto.getIdentifier());
        List<SearchCriteriaHistoryDto> list = this.getSearchCriteriaHistoryDtos();
        Assert.isTrue((list != null && list.size() < 10 ? 1 : 0) != 0, (String)"L\u2019enregistrement n'est pas possible car vous avez atteint le nombre limite de recherches enregistr\u00e9es. Veuillez supprimer au moins une de vos recherches.");
    }

    protected SearchCriteriaHistoryRepository getRepository() {
        return this.searchCriteriaHistoryRepo;
    }

    protected Class<SearchCriteriaHistory> getEntityClass() {
        return SearchCriteriaHistory.class;
    }

    protected String getObjectName() {
        return "searchCriteriaHistory";
    }

    protected Converter<SearchCriteriaHistoryDto, SearchCriteriaHistory> getConverter() {
        return this.searchCriteriaHistoryConverter;
    }

    @Generated
    public SearchCriteriaHistoryRepository getSearchCriteriaHistoryRepo() {
        return this.searchCriteriaHistoryRepo;
    }

    @Generated
    public SearchCriteriaHistoryConverter getSearchCriteriaHistoryConverter() {
        return this.searchCriteriaHistoryConverter;
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }
}

