/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchEliminationInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchMgtRulesInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchUnitExportCsvInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ExportDipInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ExternalParametersService;
import fr.gouv.vitamui.archive.internal.server.service.TransferVitamOperationsInternalService;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.PersistentIdentifierResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@RestController
@RequestMapping(value={"/archives-search"})
@Api(tags={"archives search"}, value="Archives units search")
public class ArchiveSearchInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchInternalController.class);
    private static final String MANDATORY_PARAMETERS = "The tenant Id and the SearchCriteria are mandatory parameters: ";
    private static final String IDENTIFIER_MANDATORY = "The identifier are mandatory parameters: ";
    private final ArchiveSearchInternalService archiveInternalService;
    private final ArchiveSearchUnitExportCsvInternalService archiveSearchUnitExportCsvInternalService;
    private final ExportDipInternalService exportDipInternalService;
    private final TransferVitamOperationsInternalService transferVitamOperationsInternalService;
    private final ArchiveSearchEliminationInternalService archiveSearchEliminationInternalService;
    private final ArchiveSearchMgtRulesInternalService archiveSearchMgtRulesInternalService;
    private final InternalSecurityService securityService;
    private final ExternalParametersService externalParametersService;
    private final ObjectMapper objectMapper;

    @Autowired
    public ArchiveSearchInternalController(ArchiveSearchInternalService archiveInternalService, InternalSecurityService securityService, ObjectMapper objectMapper, ArchiveSearchUnitExportCsvInternalService archiveSearchUnitExportCsvInternalService, ExportDipInternalService exportDipInternalService, TransferVitamOperationsInternalService transferVitamOperationsInternalService, ArchiveSearchMgtRulesInternalService archiveSearchMgtRulesInternalService, ArchiveSearchEliminationInternalService archiveSearchEliminationInternalService, ExternalParametersService externalParametersService) {
        this.archiveInternalService = archiveInternalService;
        this.securityService = securityService;
        this.objectMapper = objectMapper;
        this.archiveSearchUnitExportCsvInternalService = archiveSearchUnitExportCsvInternalService;
        this.exportDipInternalService = exportDipInternalService;
        this.transferVitamOperationsInternalService = transferVitamOperationsInternalService;
        this.archiveSearchEliminationInternalService = archiveSearchEliminationInternalService;
        this.archiveSearchMgtRulesInternalService = archiveSearchMgtRulesInternalService;
        this.externalParametersService = externalParametersService;
    }

    @PostMapping(value={"/search"})
    public ArchiveUnitsDto searchArchiveUnitsByCriteria(@RequestBody SearchCriteriaDto searchQuery) throws VitamClientException, IOException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{searchQuery});
        LOGGER.debug("Calling service searchArchiveUnits By Criteria {} ", (Object)searchQuery);
        return this.archiveInternalService.searchArchiveUnitsByCriteria(searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/filling-holding-schema"})
    public VitamUISearchResponseDto getFillingHoldingScheme() throws VitamClientException, IOException, PreconditionFailedException {
        LOGGER.debug("Get filing plan");
        return (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)this.archiveInternalService.getFillingHoldingScheme(this.externalParametersService.buildVitamContextFromExternalParam()), VitamUISearchResponseDto.class);
    }

    @GetMapping(value={"/archiveunit/{id}"})
    public ResultsDto findUnitById(@PathVariable(value="id") String unitId) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY, (String[])new String[]{unitId});
        SanityChecker.checkSecureParameter((String[])new String[]{unitId});
        LOGGER.debug("UA Details  by id {}", (Object)unitId);
        return this.archiveInternalService.findArchiveUnitById(unitId, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/object/{id}"})
    public ResultsDto findObjectById(@PathVariable(value="id") String objectId) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY, (String[])new String[]{objectId});
        SanityChecker.checkSecureParameter((String[])new String[]{objectId});
        LOGGER.debug("Get ObjectGroup By id : {}", (Object)objectId);
        return this.archiveInternalService.findObjectById(objectId, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/downloadobjectfromunit/{id}"}, produces={"application/octet-stream"})
    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(@PathVariable(value="id") String objectId, @RequestParam(value="usage") String usage, @RequestParam(value="version") Integer version) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY, (String[])new String[]{objectId});
        SanityChecker.checkSecureParameter((String[])new String[]{objectId, usage});
        LOGGER.debug("Download Archive Unit Object with id {}", (Object)objectId);
        VitamContext vitamContext = new VitamContext(this.securityService.getTenantIdentifier()).setAccessContract(this.externalParametersService.retrieveAccessContractFromExternalParam()).setApplicationSessionId(this.securityService.getApplicationId());
        return Mono.fromCallable(() -> {
            Response response = this.archiveInternalService.downloadObjectFromUnit(objectId, usage, version, vitamContext);
            return new InputStreamResource((InputStream)response.getEntity());
        }).subscribeOn(Schedulers.boundedElastic()).flatMap(resource -> Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noCache())).body(resource)));
    }

    @PostMapping(value={"/export-csv-search"})
    public ResponseEntity<Resource> exportCsvArchiveUnitsByCriteria(@RequestBody SearchCriteriaDto searchQuery) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        LOGGER.debug("Export to CSV file Archive Units by criteria {}", (Object)searchQuery);
        Resource exportedResult = this.archiveSearchUnitExportCsvInternalService.exportToCsvSearchArchiveUnitsByCriteria(searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
        return new ResponseEntity((Object)exportedResult, HttpStatus.OK);
    }

    @PostMapping(value={"/export-dip"})
    public ResponseEntity<String> exportDIPByCriteria(@RequestBody ExportDipCriteriaDto exportDipCriteriaDto) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)exportDipCriteriaDto);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{exportDipCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)exportDipCriteriaDto);
        LOGGER.debug("Export DIP  by criteria {}", (Object)exportDipCriteriaDto);
        String result = this.exportDipInternalService.requestToExportDIP(exportDipCriteriaDto, this.externalParametersService.buildVitamContextFromExternalParam());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/transfer-request"})
    public ResponseEntity<String> transferRequest(@RequestBody TransferRequestDto transferRequestDto) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)transferRequestDto);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{transferRequestDto});
        SanityChecker.sanitizeCriteria((Object)transferRequestDto);
        LOGGER.debug("Transfer request {}", (Object)transferRequestDto);
        String result = this.transferVitamOperationsInternalService.transferRequest(transferRequestDto, this.externalParametersService.buildVitamContextFromExternalParam());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/elimination/analysis"})
    public JsonNode startEliminationAnalysis(@RequestBody SearchCriteriaDto searchQuery) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{searchQuery});
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        LOGGER.debug("Calling elimination analysis by criteria {} ", (Object)searchQuery);
        return this.archiveSearchEliminationInternalService.startEliminationAnalysis(searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PostMapping(value={"/elimination/action"})
    public JsonNode startEliminationAction(@RequestBody SearchCriteriaDto searchQuery) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{searchQuery});
        LOGGER.debug("Calling elimination action by criteria {} ", (Object)searchQuery);
        return this.archiveSearchEliminationInternalService.startEliminationAction(searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PostMapping(value={"/units/rules"})
    public ResponseEntity<String> updateArchiveUnitsRules(@RequestBody RuleSearchCriteriaDto ruleSearchCriteriaDto) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ruleSearchCriteriaDto);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{ruleSearchCriteriaDto});
        LOGGER.debug("Update Archive Units Rules by criteria {}", (Object)ruleSearchCriteriaDto);
        String result = this.archiveSearchMgtRulesInternalService.updateArchiveUnitsRules(ruleSearchCriteriaDto, this.externalParametersService.buildVitamContextFromExternalParam());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/computed-inherited-rules"})
    public ResponseEntity<String> computedInheritedRules(@RequestBody SearchCriteriaDto searchCriteriaDto) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)searchCriteriaDto);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{searchCriteriaDto});
        LOGGER.debug("Computed Inherited Rules  by criteria {}", (Object)searchCriteriaDto);
        String result = this.archiveInternalService.computedInheritedRules(searchCriteriaDto, this.externalParametersService.buildVitamContextFromExternalParam());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/unit-with-inherited-rules"})
    public ResultsDto selectUnitsWithInheritedRules(@RequestBody SearchCriteriaDto searchQuery) throws InvalidParseOperationException, PreconditionFailedException, VitamClientException, IOException {
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{searchQuery});
        LOGGER.debug("Calling service select Unit With Inherited Rules By Criteria {} ", (Object)searchQuery);
        return this.archiveInternalService.selectUnitWithInheritedRules(searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PostMapping(value={"/reclassification"})
    public ResponseEntity<String> reclassification(@RequestBody ReclassificationCriteriaDto reclassificationCriteriaDto) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)reclassificationCriteriaDto);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{reclassificationCriteriaDto});
        LOGGER.debug("Reclassification query {}", (Object)reclassificationCriteriaDto);
        String result = this.archiveInternalService.reclassification(reclassificationCriteriaDto, this.externalParametersService.buildVitamContextFromExternalParam());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @ApiOperation(value="Upload an ATR for transfer acknowledgment operation", consumes="application/octet-stream")
    @PostMapping(value={"/transfer-acknowledgment"}, consumes={"application/octet-stream"})
    public String transferAcknowledgment(InputStream inputStream, @RequestHeader(value="X-Original-Filename") String originalFileName) throws PreconditionFailedException, VitamClientException {
        LOGGER.debug("[INTERNAL] : Transfer Acknowledgment Operation");
        ParameterChecker.checkParameter((String)"The fileName is mandatory parameter: ", (String[])new String[]{originalFileName});
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        LOGGER.debug("Transfer Acknowledgment : upload  atr xml filename: {}", (Object)originalFileName);
        return this.transferVitamOperationsInternalService.transferAcknowledgmentService(inputStream, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/external-ontologies"})
    public List<VitamUiOntologyDto> getExternalOntologyFieldsList() throws IOException {
        LOGGER.debug("[INTERNAL] : Get All ontologies values for tenant {}", (Object)this.securityService.getTenantIdentifier());
        Integer tenantId = this.securityService.getTenantIdentifier();
        return this.archiveInternalService.readExternalOntologiesFromFile(tenantId);
    }

    @GetMapping(value={"/units-by-persistent-identifier"})
    public PersistentIdentifierResponseDto findUnitsByPersistentIdentifier(@RequestParam(value="id") String arkId) throws VitamClientException {
        LOGGER.debug("[INTERNAL] : Get units by persistent identifier {}", (Object)arkId);
        PersistentIdentifierResponseDto persistentIdentifierResponse = this.archiveInternalService.findUnitsByPersistentIdentifier(arkId, this.externalParametersService.buildVitamContextFromExternalParam());
        LOGGER.debug("[INTERNAL] : persistentIdentifierResponse = {}", (Object)persistentIdentifierResponse);
        return persistentIdentifierResponse;
    }

    @GetMapping(value={"/objects-by-persistent-identifier"})
    public PersistentIdentifierResponseDto findObjectsByPersistentIdentifier(@RequestParam(value="id") String arkId) throws VitamClientException {
        LOGGER.debug("[INTERNAL] : Get objects by persistent identifier {}", (Object)arkId);
        PersistentIdentifierResponseDto persistentIdentifierResponse = this.archiveInternalService.findObjectsByPersistentIdentifier(arkId, this.externalParametersService.buildVitamContextFromExternalParam());
        LOGGER.debug("[INTERNAL] : persistentIdentifierResponse = {}", (Object)persistentIdentifierResponse);
        return persistentIdentifierResponse;
    }

    @Generated
    public ArchiveSearchInternalService getArchiveInternalService() {
        return this.archiveInternalService;
    }

    @Generated
    public ArchiveSearchUnitExportCsvInternalService getArchiveSearchUnitExportCsvInternalService() {
        return this.archiveSearchUnitExportCsvInternalService;
    }

    @Generated
    public ExportDipInternalService getExportDipInternalService() {
        return this.exportDipInternalService;
    }

    @Generated
    public TransferVitamOperationsInternalService getTransferVitamOperationsInternalService() {
        return this.transferVitamOperationsInternalService;
    }

    @Generated
    public ArchiveSearchEliminationInternalService getArchiveSearchEliminationInternalService() {
        return this.archiveSearchEliminationInternalService;
    }

    @Generated
    public ArchiveSearchMgtRulesInternalService getArchiveSearchMgtRulesInternalService() {
        return this.archiveSearchMgtRulesInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public ExternalParametersService getExternalParametersService() {
        return this.externalParametersService;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

