/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.internal.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.external.client.IngestCollection;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitam.ingest.external.client.IngestExternalClient;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.exception.IngestFileGenerationException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.commons.vitam.api.ingest.IngestService;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.internal.client.CustomerInternalRestClient;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.ingest.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.ingest.common.dto.ArchiveUnitDto;
import fr.gouv.vitamui.ingest.internal.server.rest.IngestInternalController;
import fr.gouv.vitamui.ingest.internal.server.service.AccessContractInternalService;
import fr.gouv.vitamui.ingest.internal.server.service.IngestConverter;
import fr.gouv.vitamui.ingest.internal.server.service.IngestExternalParametersService;
import fr.gouv.vitamui.ingest.internal.server.service.IngestGeneratorODTFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.odftoolkit.simple.TextDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;

public class IngestInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestInternalController.class);
    private static final String ILLEGAL_CHARACTERS = "[\ufeff-\uffff]";
    private static final String SELECTED_ORIGINATING_AGENCIES = "SELECTED_ORIGINATING_AGENCIES";
    private final InternalSecurityService internalSecurityService;
    private final IngestExternalClient ingestExternalClient;
    private final IngestService ingestService;
    private final LogbookService logbookService;
    private final ObjectMapper objectMapper;
    private final CustomerInternalRestClient customerInternalRestClient;
    private final IngestGeneratorODTFile ingestGeneratorODTFile;
    private final IngestExternalParametersService ingestExternalParametersService;
    private final AccessContractInternalService accessContractInternalService;

    @Autowired
    public IngestInternalService(InternalSecurityService internalSecurityService, LogbookService logbookService, ObjectMapper objectMapper, IngestExternalClient ingestExternalClient, IngestService ingestService, CustomerInternalRestClient customerInternalRestClient, IngestGeneratorODTFile ingestGeneratorODTFile, IngestExternalParametersService ingestExternalParametersService, AccessContractInternalService accessContractInternalService) {
        this.internalSecurityService = internalSecurityService;
        this.ingestExternalClient = ingestExternalClient;
        this.logbookService = logbookService;
        this.objectMapper = objectMapper;
        this.ingestService = ingestService;
        this.customerInternalRestClient = customerInternalRestClient;
        this.ingestGeneratorODTFile = ingestGeneratorODTFile;
        this.ingestExternalParametersService = ingestExternalParametersService;
        this.accessContractInternalService = accessContractInternalService;
    }

    public RequestResponseOK upload(MultipartFile path, String contextId, String action) throws IngestExternalException {
        VitamContext vitamContext = this.internalSecurityService.buildVitamContext(this.internalSecurityService.getTenantIdentifier());
        RequestResponse ingestResponse = null;
        try {
            LOGGER.info("Upload EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            ingestResponse = this.ingestService.ingest(vitamContext, path.getInputStream(), contextId, action);
            LOGGER.info("The recieved stream size : " + path.getInputStream().available() + " is sent to Vitam");
            if (ingestResponse.isOk()) {
                LOGGER.debug("Ingest passed successfully : " + ingestResponse.toString());
            } else {
                LOGGER.debug("Ingest failed with status : " + ingestResponse.getHttpCode());
            }
        }
        catch (IngestExternalException | IOException e) {
            LOGGER.debug("Error sending upload to vitam ", e);
            throw new IngestExternalException(e);
        }
        return (RequestResponseOK)ingestResponse;
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        Optional<AccessContractDto> accessContractDtoOpt;
        Optional<String> accessContractdOpt = this.ingestExternalParametersService.retrieveProfilAccessContract(this.internalSecurityService.getHttpContext());
        Set originatingAgencies = new HashSet();
        Boolean everyOriginatingAgency = false;
        if (accessContractdOpt.isPresent() && (accessContractDtoOpt = this.accessContractInternalService.getOne(vitamContext, accessContractdOpt.get())).isPresent()) {
            originatingAgencies = accessContractDtoOpt.get().getOriginatingAgencies();
            everyOriginatingAgency = accessContractDtoOpt.get().getEveryOriginatingAgency();
        }
        Map vitamCriteria = new HashMap();
        try {
            LOGGER.info(" All ingests EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
                if (!everyOriginatingAgency.booleanValue()) {
                    vitamCriteria.put(SELECTED_ORIGINATING_AGENCIES, originatingAgencies.stream().collect(Collectors.toList()));
                }
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find LogbookOperations with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        LogbookOperationsResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<LogbookOperationDto> valuesDto = IngestConverter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("After Conversion: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public LogbookOperationDto getOne(VitamContext vitamContext, String id) {
        try {
            LOGGER.info("Ingest EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperationbyId(id, vitamContext);
            LOGGER.debug("One Ingest Response: {}: ", (Object)requestResponse);
            LogbookOperationsResponseDto logbookOperationDtos = (LogbookOperationsResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), LogbookOperationsResponseDto.class);
            List<LogbookOperationDto> singleLogbookOperationDto = IngestConverter.convertVitamsToDtos(logbookOperationDtos.getResults());
            return singleLogbookOperationDto.get(0);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find LogbookOperations", e);
        }
    }

    private LogbookOperationsResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All Ingest EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperations(query, vitamContext);
            LOGGER.debug("Response: {}: ", (Object)requestResponse);
            LogbookOperationsResponseDto logbookOperationsResponseDto = (LogbookOperationsResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), LogbookOperationsResponseDto.class);
            LOGGER.debug("Response DTO: {}: ", (Object)logbookOperationsResponseDto);
            return logbookOperationsResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find LogbookOperations", e);
        }
    }

    public String getManifestAsString(VitamContext vitamContext, String id) {
        try {
            String manifest = "";
            Response response = this.ingestExternalClient.downloadObjectAsync(vitamContext, id, IngestCollection.MANIFESTS);
            Object entity = response.getEntity();
            if (entity instanceof InputStream) {
                InputStreamResource resource = new InputStreamResource((InputStream)entity);
                manifest = this.ingestGeneratorODTFile.resourceAsString((Resource)resource).replaceAll(ILLEGAL_CHARACTERS, "");
            }
            LOGGER.info("Manifest EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            return manifest;
        }
        catch (VitamClientException e) {
            LOGGER.error("Unable to find the Manifest {}", (Object)e.getMessage());
            throw new InternalServerException("Unable to find the Manifest", (Throwable)e);
        }
    }

    public String getAtrAsString(VitamContext vitamContext, String id) {
        try {
            String atr = "";
            Response response = this.ingestExternalClient.downloadObjectAsync(vitamContext, id, IngestCollection.ARCHIVETRANSFERREPLY);
            Object entity = response.getEntity();
            if (entity instanceof InputStream) {
                InputStreamResource resource = new InputStreamResource((InputStream)entity);
                atr = this.ingestGeneratorODTFile.resourceAsString((Resource)resource).replaceAll(ILLEGAL_CHARACTERS, "");
            }
            LOGGER.info("ATR EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            return atr;
        }
        catch (VitamClientException e) {
            LOGGER.error("Unable to find ATR {}", (Object)e.getMessage());
            throw new InternalServerException("Unable to find ATR", (Throwable)e);
        }
    }

    public byte[] generateODTReport(VitamContext vitamContext, String id) throws IOException, URISyntaxException, IngestFileGenerationException {
        CustomerDto myCustomer = this.customerInternalRestClient.getMyCustomer(this.internalSecurityService.getHttpContext());
        Resource customerLogo = null;
        try {
            TextDocument document;
            LOGGER.info("Generate ODT Report : get Manifest and ATR of the operation ID : {} ", (Object)id);
            Document atr = this.ingestGeneratorODTFile.convertStringToXMLDocument(this.getAtrAsString(vitamContext, id));
            Document manifest = this.ingestGeneratorODTFile.convertStringToXMLDocument(this.getManifestAsString(vitamContext, id));
            try {
                document = TextDocument.newTextDocument();
            }
            catch (Exception e) {
                LOGGER.error("Error to initialize the document : {} ", (Object)e.getMessage());
                throw new IngestFileGenerationException("Error to initialize the document : {} ", (Throwable)e);
            }
            if (myCustomer.isHasCustomGraphicIdentity()) {
                customerLogo = (Resource)this.customerInternalRestClient.getLogo(this.internalSecurityService.getHttpContext(), myCustomer.getId(), AttachmentType.HEADER).getBody();
            }
            List<ArchiveUnitDto> archiveUnitDtoList = this.ingestGeneratorODTFile.getValuesForDynamicTable(atr, manifest);
            LOGGER.info("Generate ODT Report : get customer : {} logo ", (Object)myCustomer.getId());
            this.ingestGeneratorODTFile.generateDocumentHeader(document, myCustomer, customerLogo);
            LOGGER.info("Generate ODT Report : generate the first page content ");
            this.ingestGeneratorODTFile.generateFirstTitle(document);
            this.ingestGeneratorODTFile.generateServicesTable(document, manifest);
            this.ingestGeneratorODTFile.generateDepositDataTable(document, manifest, archiveUnitDtoList);
            this.ingestGeneratorODTFile.generateOperationDataTable(document, manifest, id);
            this.ingestGeneratorODTFile.generateResponsibleSignatureTable(document);
            document.addPageBreak();
            LOGGER.info("Generate ODT Report : generate the second page content");
            this.ingestGeneratorODTFile.generateSecondtTitle(document);
            this.ingestGeneratorODTFile.generateArchiveUnitDetailsTable(document, archiveUnitDtoList);
            LOGGER.info("Generate ODT Report EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            try {
                document.save((OutputStream)result);
            }
            catch (Exception e) {
                LOGGER.error("Error to save the document : {} ", (Object)e.getMessage());
                throw new IngestFileGenerationException("Error to save the document : {} ", (Throwable)e);
            }
            return result.toByteArray();
        }
        catch (IngestFileGenerationException | IOException | URISyntaxException e) {
            LOGGER.error("Error with generating Report : {} ", (Object)e.getMessage());
            throw new IngestFileGenerationException("Unable to generate the ingest report ", e);
        }
    }

    public String streamingUpload(InputStream inputStream, String contextId, String action) throws IngestExternalException {
        try {
            VitamContext vitamContext = this.internalSecurityService.buildVitamContext(this.internalSecurityService.getTenantIdentifier());
            RequestResponse ingestResponse = this.ingestExternalClient.ingest(vitamContext, inputStream, contextId, action);
            if (!ingestResponse.isOk()) {
                LOGGER.debug("Error on ingest streaming Upload ");
                throw new VitamClientException("Error on ingest streaming Upload");
            }
            String operationId = (String)ingestResponse.getVitamHeaders().get("X-Request-Id");
            LOGGER.debug("Ingest passed successfully : " + ingestResponse + " with operationId = " + operationId);
            return operationId;
        }
        catch (Exception e) {
            LOGGER.debug("Error sending upload to vitam ", (Throwable)e);
            throw new IngestExternalException((Throwable)e);
        }
    }
}

