/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.referential.common.service.VitamUIManagementContractService;
import java.lang.reflect.Constructor;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerIdentityConfiguration.class})
public class VitamUIManagementContractServiceTest {
    private AdminExternalClient adminExternalClient;
    private VitamUIManagementContractService vitamUIManagementContractService;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.vitamUIManagementContractService = new VitamUIManagementContractService(this.adminExternalClient);
        PowerMock.suppress((Constructor)PowerMock.constructor(ServerIdentityConfiguration.class));
        PowerMock.mockStatic(ServerIdentityConfiguration.class);
        ServerIdentityConfiguration serverIdentityConfigurationMock = (ServerIdentityConfiguration)PowerMock.createMock(ServerIdentityConfiguration.class);
        EasyMock.expect((Object)ServerIdentityConfiguration.getInstance()).andReturn((Object)serverIdentityConfigurationMock).anyTimes();
        EasyMock.expect((Object)serverIdentityConfigurationMock.getLoggerMessagePrepend()).andReturn((Object)"LOG TESTS VitamUIAccessContractServiceTest - ").anyTimes();
        PowerMock.replay((Object[])new Object[]{ServerIdentityConfiguration.class});
        PowerMock.replay((Object[])new Object[]{serverIdentityConfigurationMock});
    }

    @Test
    public void patchAccessContract_should_return_ok_when_vitamAdminExternalClient_ok() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_ok$0(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchAccessContract_should_return_ok_when_vitamAdminExternalClient_400() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_400$1(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchAccessContract_should_throw_InvalidParseOperationException_when_vitamAdminExternalClient_throws_InvalidParseOperationException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).andThrow((Throwable)new InvalidParseOperationException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_throw_InvalidParseOperationException_when_vitamAdminExternalClient_throws_InvalidParseOperationException$2(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(InvalidParseOperationException.class);
    }

    @Test
    public void patchAccessContract_should_throw_AccessExternalClientException_when_vitamAdminExternalClient_throws_AccessExternalClientException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateManagementContract(vitamSecurityProfile, id, (JsonNode)jsonNode)).andThrow((Throwable)new AccessExternalClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchAccessContract_should_throw_AccessExternalClientException_when_vitamAdminExternalClient_throws_AccessExternalClientException$3(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(AccessExternalClientException.class);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_throw_AccessExternalClientException_when_vitamAdminExternalClient_throws_AccessExternalClientException$3(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_throw_InvalidParseOperationException_when_vitamAdminExternalClient_throws_InvalidParseOperationException$2(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_400$1(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchAccessContract_should_return_ok_when_vitamAdminExternalClient_ok$0(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamUIManagementContractService.patchManagementContract(vitamSecurityProfile, id, jsonNode);
    }
}

