/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.referential.common.service.VitamSecurityProfileService;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerIdentityConfiguration.class})
public class VitamSecurityProfileServiceTest {
    private AdminExternalClient adminExternalClient;
    private ObjectMapper objectMapper;
    private VitamSecurityProfileService vitamSecurityProfileService;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.vitamSecurityProfileService = new VitamSecurityProfileService(this.adminExternalClient, this.objectMapper);
        PowerMock.suppress((Constructor)PowerMock.constructor(ServerIdentityConfiguration.class));
        PowerMock.mockStatic(ServerIdentityConfiguration.class);
        ServerIdentityConfiguration serverIdentityConfigurationMock = (ServerIdentityConfiguration)PowerMock.createMock(ServerIdentityConfiguration.class);
        EasyMock.expect((Object)ServerIdentityConfiguration.getInstance()).andReturn((Object)serverIdentityConfigurationMock).anyTimes();
        EasyMock.expect((Object)serverIdentityConfigurationMock.getLoggerMessagePrepend()).andReturn((Object)"LOG TESTS VitamSecurityProfileServiceTest - ").anyTimes();
        PowerMock.replay((Object[])new Object[]{ServerIdentityConfiguration.class});
        PowerMock.replay((Object[])new Object[]{serverIdentityConfigurationMock});
    }

    @Test
    public void patchSecurityProfile_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateSecurityProfile(vitamSecurityProfile, id, (JsonNode)jsonNode)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchSecurityProfile_should_return_ok_when_vitamclient_ok$0(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchSecurityProfile_should_return_ok_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateSecurityProfile(vitamSecurityProfile, id, (JsonNode)jsonNode)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchSecurityProfile_should_return_ok_when_vitamclient_400$1(vitamSecurityProfile, id, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateSecurityProfile(vitamSecurityProfile, id, (JsonNode)jsonNode)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(vitamSecurityProfile, id, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void deleteSecurityProfile_should_return_ok_when_vitamclient_ok() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "1";
        EasyMock.expect((Object)this.adminExternalClient.createSecurityProfiles((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfiles((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileService.deleteSecurityProfile(vitamSecurityProfile, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteSecurityProfile_should_throw_JsonProcessingException_when_vitamclient_400() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "1";
        EasyMock.expect((Object)this.adminExternalClient.createSecurityProfiles((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfiles((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileService.deleteSecurityProfile(vitamSecurityProfile, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        EasyMock.expect((Object)this.adminExternalClient.createSecurityProfiles((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)new Select().getFinalSelect())).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileService.deleteSecurityProfile(vitamSecurityProfile, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findSecurityProfiles_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)jsonNode)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findSecurityProfiles_should_return_ok_when_vitamclient_ok$6(vitamSecurityProfile, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void findSecurityProfiles_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)jsonNode)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findSecurityProfiles_should_throw_BadRequestException_when_vitamclient_400$7(vitamSecurityProfile, (JsonNode)jsonNode)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findSecurityProfiles_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfiles(vitamSecurityProfile, (JsonNode)jsonNode)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findSecurityProfiles_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$8(vitamSecurityProfile, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findSecurityProfileById_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String securityProfileId = "SPId_0";
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileService.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).doesNotThrowAnyException();
    }

    @Test
    public void findSecurityProfileById_should_return_InternalServerException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String securityProfileId = "SPId_0";
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileService.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findSecurityProfileById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamSecurityProfile = new VitamContext(Integer.valueOf(0));
        String securityProfileId = "SPId_0";
        EasyMock.expect((Object)this.adminExternalClient.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamSecurityProfileService.findSecurityProfileById(vitamSecurityProfile, securityProfileId)).isInstanceOf(VitamClientException.class);
    }

    private /* synthetic */ void lambda$findSecurityProfiles_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$8(VitamContext vitamSecurityProfile, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileService.findSecurityProfiles(vitamSecurityProfile, jsonNode);
    }

    private /* synthetic */ void lambda$findSecurityProfiles_should_throw_BadRequestException_when_vitamclient_400$7(VitamContext vitamSecurityProfile, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileService.findSecurityProfiles(vitamSecurityProfile, jsonNode);
    }

    private /* synthetic */ void lambda$findSecurityProfiles_should_return_ok_when_vitamclient_ok$6(VitamContext vitamSecurityProfile, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileService.findSecurityProfiles(vitamSecurityProfile, jsonNode);
    }

    private /* synthetic */ void lambda$patchSecurityProfile_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileService.patchSecurityProfile(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchSecurityProfile_should_return_ok_when_vitamclient_400$1(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileService.patchSecurityProfile(vitamSecurityProfile, id, jsonNode);
    }

    private /* synthetic */ void lambda$patchSecurityProfile_should_return_ok_when_vitamclient_ok$0(VitamContext vitamSecurityProfile, String id, JsonNode jsonNode) throws Throwable {
        this.vitamSecurityProfileService.patchSecurityProfile(vitamSecurityProfile, id, jsonNode);
    }
}

