/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.referential.common.service.VitamFileFormatService;
import java.lang.reflect.Constructor;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerIdentityConfiguration.class})
public class VitamFileFormatServiceTest {
    private AdminExternalClient adminExternalClient;
    private AccessExternalClient accessExternalClient;
    private VitamFileFormatService vitamFileFormatService;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.accessExternalClient = (AccessExternalClient)EasyMock.mock(AccessExternalClient.class);
        this.objectMapper = new ObjectMapper();
        this.vitamFileFormatService = new VitamFileFormatService(this.adminExternalClient, this.objectMapper, this.accessExternalClient);
        PowerMock.suppress((Constructor)PowerMock.constructor(ServerIdentityConfiguration.class));
        PowerMock.mockStatic(ServerIdentityConfiguration.class);
        ServerIdentityConfiguration serverIdentityConfigurationMock = (ServerIdentityConfiguration)PowerMock.createMock(ServerIdentityConfiguration.class);
        EasyMock.expect((Object)ServerIdentityConfiguration.getInstance()).andReturn((Object)serverIdentityConfigurationMock).anyTimes();
        EasyMock.expect((Object)serverIdentityConfigurationMock.getLoggerMessagePrepend()).andReturn((Object)"LOG TESTS VitamFileFormatServiceTest - ").anyTimes();
        PowerMock.replay((Object[])new Object[]{ServerIdentityConfiguration.class});
        PowerMock.replay((Object[])new Object[]{serverIdentityConfigurationMock});
    }

    @Test
    public void findFileFormats_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)select)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findFileFormats_should_return_ok_when_vitamclient_ok$0(vitamContext, (JsonNode)select)).doesNotThrowAnyException();
    }

    @Test
    public void findFileFormats_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)select)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findFileFormats_should_throw_BadRequestException_when_vitamclient_400$1(vitamContext, (JsonNode)select)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findFileFormats_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)select)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findFileFormats_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(vitamContext, (JsonNode)select)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findFileFormatById_should_return_ok_when_vitamclient_ok() throws VitamClientException, InvalidCreateOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "Id_0";
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"PUID", (String)id));
        ObjectNode selectQuery = select.getFinalSelect();
        EasyMock.expect((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)selectQuery)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamFileFormatService.findFileFormatById(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void findFileFormatById_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException, InvalidCreateOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "Id_0";
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"PUID", (String)id));
        ObjectNode selectQuery = select.getFinalSelect();
        EasyMock.expect((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)selectQuery)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamFileFormatService.findFileFormatById(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findFileFormatById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException, InvalidCreateOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "Id_0";
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)"PUID", (String)id));
        ObjectNode selectQuery = select.getFinalSelect();
        EasyMock.expect((Object)this.adminExternalClient.findFormats(vitamContext, (JsonNode)selectQuery)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamFileFormatService.findFileFormatById(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    private /* synthetic */ void lambda$findFileFormats_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamFileFormatService.findFileFormats(vitamContext, select);
    }

    private /* synthetic */ void lambda$findFileFormats_should_throw_BadRequestException_when_vitamclient_400$1(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamFileFormatService.findFileFormats(vitamContext, select);
    }

    private /* synthetic */ void lambda$findFileFormats_should_return_ok_when_vitamclient_ok$0(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamFileFormatService.findFileFormats(vitamContext, select);
    }
}

