/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.common.dto.ContextVitamDto;
import fr.gouv.vitamui.referential.common.dto.PermissionDto;
import fr.gouv.vitamui.referential.common.dto.converter.ContextDtoConverterUtil;
import fr.gouv.vitamui.referential.common.service.VitamContextService;
import fr.gouv.vitamui.referential.common.utils.ReferentialDtoBuilder;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerIdentityConfiguration.class})
public class VitamContextServiceTest {
    private AdminExternalClient adminExternalClient;
    private VitamContextService vitamContextService;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.vitamContextService = new VitamContextService(this.adminExternalClient, this.objectMapper);
        this.objectMapper = new ObjectMapper();
        PowerMock.suppress((Constructor)PowerMock.constructor(ServerIdentityConfiguration.class));
        PowerMock.mockStatic(ServerIdentityConfiguration.class);
        ServerIdentityConfiguration serverIdentityConfigurationMock = (ServerIdentityConfiguration)PowerMock.createMock(ServerIdentityConfiguration.class);
        EasyMock.expect((Object)ServerIdentityConfiguration.getInstance()).andReturn((Object)serverIdentityConfigurationMock).anyTimes();
        EasyMock.expect((Object)serverIdentityConfigurationMock.getLoggerMessagePrepend()).andReturn((Object)"LOG TESTS VitamContextServiceTest - ").anyTimes();
        PowerMock.replay((Object[])new Object[]{ServerIdentityConfiguration.class});
        PowerMock.replay((Object[])new Object[]{serverIdentityConfigurationMock});
    }

    @Test
    public void patchContext_should_return_ok_when_vitamclient_ok() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateContext((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_return_ok_when_vitamclient_ok$0(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchContext_should_return_ok_when_vitamclient_400() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateContext((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_return_ok_when_vitamclient_400$1(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void patchContext_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateContext((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new AccessExternalClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException$2(vitamContext, (JsonNode)jsonNode)).isInstanceOf(AccessExternalClientException.class);
    }

    @Test
    public void patchContext_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException() throws AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "0";
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.updateContext((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new InvalidParseOperationException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$patchContext_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException$3(vitamContext, (JsonNode)jsonNode)).isInstanceOf(InvalidParseOperationException.class);
    }

    @Test
    public void findContexts_should_return_ok_when_vitamclient_return_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findContexts((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findContexts_should_return_ok_when_vitamclient_return_ok$4(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void findContexts_should_throw_BadRequestException_when_vitamclient_return_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findContexts((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findContexts_should_throw_BadRequestException_when_vitamclient_return_400$5(vitamContext, (JsonNode)jsonNode)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findContexts_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findContexts((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findContexts_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$6(vitamContext, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findContextById_should_return_ok_when_vitamclient_return_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contextId = "CId_0";
        EasyMock.expect((Object)this.adminExternalClient.findContextById((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamContextService.findContextById(vitamContext, contextId)).doesNotThrowAnyException();
    }

    @Test
    public void findContextById_should_throw_InternalServerException_when_vitamclient_return_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contextId = "CId_0";
        EasyMock.expect((Object)this.adminExternalClient.findContextById((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamContextService.findContextById(vitamContext, contextId)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findContextById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contextId = "CId_0";
        EasyMock.expect((Object)this.adminExternalClient.findContextById((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamContextService.findContextById(vitamContext, contextId)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void should_convert_contextDto_to_vitamContextDto() {
        ContextDto contextModels = ReferentialDtoBuilder.getContextDto();
        List contextVitamDtos = ContextDtoConverterUtil.convertContextsToModelOfCreation(Collections.singletonList(contextModels));
        JsonNode jsonNodeContextDto = (JsonNode)this.objectMapper.convertValue((Object)contextModels.getPermissions(), JsonNode.class);
        JsonNode jsonNodeContextVitamDto = (JsonNode)this.objectMapper.convertValue((Object)((ContextVitamDto)contextVitamDtos.get(0)).getPermissions(), JsonNode.class);
        Assertions.assertThat((Iterable)jsonNodeContextDto).isEqualTo((Object)jsonNodeContextVitamDto);
    }

    @Test
    public void should_convert_contextDtos_to_vitamContextDtos() {
        ContextDto contextModels = ReferentialDtoBuilder.buildContextDto(null);
        Set<PermissionDto> permissionDtos = ReferentialDtoBuilder.buildPermissions();
        contextModels.setPermissions(permissionDtos);
        List contextVitamDtos = ContextDtoConverterUtil.convertContextsToModelOfCreation(Collections.singletonList(contextModels));
        JsonNode jsonNodeContextDto = (JsonNode)this.objectMapper.convertValue((Object)contextModels.getPermissions(), JsonNode.class);
        JsonNode jsonNodeContextVitamDto = (JsonNode)this.objectMapper.convertValue((Object)((ContextVitamDto)contextVitamDtos.get(0)).getPermissions(), JsonNode.class);
        Assertions.assertThat((Iterable)jsonNodeContextDto).hasSameElementsAs((Iterable)jsonNodeContextVitamDto);
    }

    private /* synthetic */ void lambda$findContexts_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$6(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextService.findContexts(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findContexts_should_throw_BadRequestException_when_vitamclient_return_400$5(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextService.findContexts(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findContexts_should_return_ok_when_vitamclient_return_ok$4(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextService.findContexts(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException$3(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextService.patchContext(vitamContext, "0", jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException$2(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextService.patchContext(vitamContext, "0", jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_return_ok_when_vitamclient_400$1(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextService.patchContext(vitamContext, "0", jsonNode);
    }

    private /* synthetic */ void lambda$patchContext_should_return_ok_when_vitamclient_ok$0(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.vitamContextService.patchContext(vitamContext, "0", jsonNode);
    }
}

