/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.data.core.management;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingStorageWorkspaceException;
import fr.gouv.vitam.processing.common.model.DistributorIndex;
import fr.gouv.vitam.processing.common.model.PauseRecover;
import fr.gouv.vitam.processing.common.model.ProcessWorkflow;
import fr.gouv.vitam.processing.data.core.management.ProcessDataManagement;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;

public class WorkspaceProcessDataManagement
implements ProcessDataManagement {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkspaceProcessDataManagement.class);
    private static final ProcessDataManagement INSTANCE = new WorkspaceProcessDataManagement();
    private final WorkspaceClientFactory workspaceClientFactory;

    private WorkspaceProcessDataManagement() {
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
    }

    @VisibleForTesting
    public WorkspaceProcessDataManagement(WorkspaceClientFactory workspaceClientFactory) {
        this.workspaceClientFactory = workspaceClientFactory;
    }

    public static ProcessDataManagement getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean createProcessContainer() throws ProcessingStorageWorkspaceException {
        boolean bl;
        block9: {
            if (this.isProcessContainerExist()) {
                return false;
            }
            WorkspaceClient client = this.workspaceClientFactory.getClient();
            try {
                client.createContainer("process");
                bl = true;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException exc) {
                    LOGGER.error((Throwable)exc);
                    throw new ProcessingStorageWorkspaceException((Throwable)exc);
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public boolean isProcessContainerExist() throws ProcessingStorageWorkspaceException {
        boolean bl;
        block8: {
            WorkspaceClient client = this.workspaceClientFactory.getClient();
            try {
                bl = client.isExistingContainer("process");
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException exc) {
                    throw new ProcessingStorageWorkspaceException((Throwable)exc);
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public boolean createFolder(String folderName) throws ProcessingStorageWorkspaceException {
        boolean bl;
        block10: {
            if (this.isFolderExist(folderName)) {
                return false;
            }
            WorkspaceClient client = this.workspaceClientFactory.getClient();
            try {
                client.createFolder("process", folderName);
                bl = true;
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException exc) {
                    throw new ProcessingStorageWorkspaceException((Throwable)exc);
                }
                catch (ContentAddressableStorageAlreadyExistException e) {
                    LOGGER.warn((Throwable)e);
                    return false;
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public boolean isFolderExist(String folderName) throws ProcessingStorageWorkspaceException {
        boolean bl;
        block8: {
            WorkspaceClient client = this.workspaceClientFactory.getClient();
            try {
                bl = client.isExistingFolder("process", folderName);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException exc) {
                    throw new ProcessingStorageWorkspaceException((Throwable)exc);
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public boolean removeFolder(String folderName) throws ProcessingStorageWorkspaceException {
        boolean bl;
        block9: {
            if (!this.isFolderExist(folderName)) {
                return false;
            }
            WorkspaceClient client = this.workspaceClientFactory.getClient();
            try {
                client.deleteFolder("process", folderName);
                bl = true;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException exc) {
                    throw new ProcessingStorageWorkspaceException(exc);
                }
            }
            client.close();
        }
        return bl;
    }

    @Override
    public void persistProcessWorkflow(String folderName, ProcessWorkflow processWorkflow) throws ProcessingStorageWorkspaceException, InvalidParseOperationException {
        LOGGER.debug("[PERSIST] workflow process with execution status : <{}>", (Object)processWorkflow.getState());
        try (WorkspaceClient client = this.workspaceClientFactory.getClient();){
            client.putObject("process", this.getPathToObjectFromFolder(folderName, processWorkflow.getOperationId()), (Object)JsonHandler.writeAsString((Object)processWorkflow).getBytes());
        }
        catch (ContentAddressableStorageServerException exc) {
            throw new ProcessingStorageWorkspaceException((Throwable)exc);
        }
    }

    @Override
    public void persistDistributorIndex(String fileName, DistributorIndex distributorIndex) throws ProcessingStorageWorkspaceException, InvalidParseOperationException {
        try (WorkspaceClient client = this.workspaceClientFactory.getClient();){
            client.putObject("process", this.getPathToObjectFromFolder("distributorIndex", fileName), (Object)JsonHandler.writeAsString((Object)distributorIndex).getBytes());
        }
        catch (ContentAddressableStorageServerException exc) {
            throw new ProcessingStorageWorkspaceException((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Optional<DistributorIndex> getDistributorIndex(String fileName) throws ProcessingStorageWorkspaceException, InvalidParseOperationException {
        WorkspaceClient client;
        Response response;
        block13: {
            Optional<DistributorIndex> optional;
            block14: {
                response = null;
                client = this.workspaceClientFactory.getClient();
                response = client.getObject("process", this.getPathToObjectFromFolder("distributorIndex", fileName));
                if (response.getStatus() != Response.Status.OK.getStatusCode()) break block13;
                InputStream is = (InputStream)response.getEntity();
                optional = Optional.of((DistributorIndex)JsonHandler.getFromInputStream((InputStream)is, DistributorIndex.class));
                if (client == null) break block14;
                client.close();
            }
            DefaultClient.staticConsumeAnyEntityAndClose((Response)response);
            return optional;
        }
        try {
            try {
                client.consumeAnyEntityAndClose(response);
                throw new ProcessingStorageWorkspaceException("Workspace error: " + response.getStatusInfo().getReasonPhrase());
                {
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            catch (ContentAddressableStorageServerException exc) {
                throw new ProcessingStorageWorkspaceException((Throwable)exc);
            }
            catch (ContentAddressableStorageNotFoundException exc) {
                LOGGER.debug((Throwable)exc);
                Optional<DistributorIndex> optional = Optional.empty();
                return optional;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            DefaultClient.staticConsumeAnyEntityAndClose(response);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ProcessWorkflow getProcessWorkflow(String folderName, String asyncId) throws ProcessingStorageWorkspaceException, InvalidParseOperationException {
        WorkspaceClient client;
        Response response;
        block11: {
            ProcessWorkflow processWorkflow;
            block12: {
                response = null;
                client = this.workspaceClientFactory.getClient();
                response = client.getObject("process", this.getPathToObjectFromFolder(folderName, asyncId));
                if (response.getStatus() != Response.Status.OK.getStatusCode()) break block11;
                InputStream is = (InputStream)response.getEntity();
                processWorkflow = (ProcessWorkflow)JsonHandler.getFromInputStream((InputStream)is, ProcessWorkflow.class);
                if (client == null) break block12;
                client.close();
            }
            DefaultClient.staticConsumeAnyEntityAndClose((Response)response);
            return processWorkflow;
        }
        try {
            try {
                client.consumeAnyEntityAndClose(response);
                throw new ProcessingStorageWorkspaceException("Workspace error: " + response.getStatusInfo().getReasonPhrase());
                {
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException exc) {
                throw new ProcessingStorageWorkspaceException(exc);
            }
        }
        catch (Throwable throwable) {
            DefaultClient.staticConsumeAnyEntityAndClose(response);
            throw throwable;
        }
    }

    @Override
    public void removeProcessWorkflow(String folderName, String asyncId) throws ProcessingStorageWorkspaceException {
        try (WorkspaceClient client = this.workspaceClientFactory.getClient();){
            String path = this.getPathToObjectFromFolder(folderName, asyncId);
            if (client.isExistingObject("process", path)) {
                client.deleteObject("process", path);
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException exc) {
            throw new ProcessingStorageWorkspaceException(exc);
        }
    }

    @Override
    public Map<String, ProcessWorkflow> getProcessWorkflowFor(Integer tenantId, String folderName) throws ProcessingStorageWorkspaceException {
        ConcurrentHashMap<String, ProcessWorkflow> result = new ConcurrentHashMap<String, ProcessWorkflow>();
        try (WorkspaceClient client = this.workspaceClientFactory.getClient();){
            List uris = (List)JsonHandler.getFromStringAsTypeReference((String)client.getListUriDigitalObjectFromFolder("process", folderName).toJsonNode().get("$results").get(0).toString(), (TypeReference)new TypeReference<List<URI>>(){});
            for (URI uri : uris) {
                try {
                    String processId = uri.getPath().substring(0, uri.getPath().lastIndexOf("."));
                    ProcessWorkflow processWorkflow = this.getProcessWorkflow(folderName, processId);
                    if (ProcessState.RUNNING.equals((Object)processWorkflow.getState())) {
                        processWorkflow.setState(ProcessState.PAUSE);
                        processWorkflow.setStatus(StatusCode.FATAL);
                        processWorkflow.setPauseRecover(PauseRecover.RECOVER_FROM_SERVER_PAUSE);
                    }
                    if (ProcessState.COMPLETED.equals((Object)processWorkflow.getState()) && null == processWorkflow.getProcessCompletedDate()) {
                        processWorkflow.setProcessCompletedDate(LocalDateUtil.now());
                    }
                    if (tenantId != null && !processWorkflow.getTenantId().equals(tenantId)) continue;
                    result.put(processWorkflow.getOperationId(), processWorkflow);
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("Error on loading old workflow {} -> cannot be resume", (Object)uri.getPath(), (Object)e);
                }
            }
        }
        catch (InvalidFormatException | InvalidParseOperationException | ContentAddressableStorageServerException e) {
            throw new ProcessingStorageWorkspaceException(e);
        }
        return result;
    }

    @Override
    public boolean removeOperationContainer(ProcessWorkflow processWorkflow, WorkspaceClientFactory workspaceClientFactory) {
        boolean bl;
        block10: {
            String operationId = processWorkflow.getOperationId();
            WorkspaceClient workspaceClient = workspaceClientFactory.getClient();
            try {
                if (workspaceClient.isExistingContainer(operationId)) {
                    workspaceClient.deleteContainer(operationId, true);
                }
                if (workspaceClient.isExistingObject("process", "distributorIndex/" + operationId + ".json")) {
                    workspaceClient.deleteObject("process", "distributorIndex/" + operationId + ".json");
                }
                bl = true;
                if (workspaceClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String msg = "Error while clear the container " + operationId + " from the workspace. The background process workflow cleaner should retry to clean the operation container";
                    LOGGER.warn(msg, (Throwable)e);
                    return false;
                }
            }
            workspaceClient.close();
        }
        return bl;
    }

    private String getObjectName(String asyncId) {
        return asyncId + ".json";
    }

    private String getPathToObjectFromFolder(String folderName, String object) {
        return folderName + "/" + this.getObjectName(object);
    }
}

