/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.ProjectModel;
import fr.gouv.vitam.collect.internal.core.common.ProjectStatus;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.repository.ProjectRepository;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProjectService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProjectService.class);
    private final ProjectRepository projectRepository;

    public ProjectService(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public void createProject(ProjectDto projectDto) throws CollectInternalException {
        String creationDate = LocalDateUtil.nowFormatted();
        ProjectModel projectModel = new ProjectModel(projectDto.getId(), projectDto.getName(), CollectHelper.mapProjectDtoToManifestContext(projectDto), ProjectStatus.OPEN, creationDate, creationDate, projectDto.getUnitUp(), projectDto.getUnitUps(), projectDto.getTenant(), projectDto.getAutomaticIngest());
        this.projectRepository.createProject(projectModel);
    }

    public Optional<ProjectDto> findProject(String id) throws CollectInternalException {
        return this.projectRepository.findProjectById(id).map(CollectHelper::convertProjectModeltoProjectDto);
    }

    public void updateProject(ProjectDto projectDto) throws CollectInternalException {
        projectDto.setStatus(projectDto.getStatus() != null ? projectDto.getStatus() : TransactionStatus.OPEN.name());
        String lastUpdate = LocalDateUtil.nowFormatted();
        ProjectModel projectModel = new ProjectModel(projectDto.getId(), projectDto.getName(), CollectHelper.mapProjectDtoToManifestContext(projectDto), ProjectStatus.valueOf(projectDto.getStatus()), projectDto.getCreationDate(), lastUpdate, projectDto.getUnitUp(), projectDto.getUnitUps(), projectDto.getTenant(), projectDto.getAutomaticIngest());
        this.projectRepository.updateProject(projectModel);
    }

    public List<ProjectDto> findProjects() throws CollectInternalException {
        List<ProjectModel> listProjects = this.projectRepository.findProjectsByTenant(ParameterHelper.getTenantParameter());
        return listProjects.stream().map(CollectHelper::convertProjectModeltoProjectDto).collect(Collectors.toList());
    }

    public List<ProjectDto> searchProject(String searchValue) throws CollectInternalException {
        List<ProjectModel> listProjects = this.projectRepository.searchProject(searchValue, ParameterHelper.getTenantParameter());
        return listProjects.stream().map(CollectHelper::convertProjectModeltoProjectDto).collect(Collectors.toList());
    }

    public void deleteProjectById(String id) {
        this.projectRepository.deleteProject(id);
    }
}

