/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterators;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalServerSideException;
import fr.gouv.vitam.collect.internal.core.common.CollectJsonMetadataLine;
import fr.gouv.vitam.collect.internal.core.common.ProjectModel;
import fr.gouv.vitam.collect.internal.core.csv.CsvHelper;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfoResolver;
import fr.gouv.vitam.collect.internal.core.helpers.JsonlMetadataFileValidator;
import fr.gouv.vitam.collect.internal.core.helpers.MetadataHelper;
import fr.gouv.vitam.collect.internal.core.helpers.TempWorkspace;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.collect.internal.core.repository.ProjectRepository;
import fr.gouv.vitam.collect.internal.core.service.CollectService;
import fr.gouv.vitam.collect.internal.core.service.MetadataService;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.model.unit.LevelType;
import fr.gouv.vitam.common.storage.compress.ArchiveEntryInputStream;
import fr.gouv.vitam.common.storage.compress.VitamArchiveStreamFactory;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipException;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.Strings;

public class FluxService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FluxService.class);
    private static final int BULK_SIZE = 1000;
    private static final String TRANSFORMED_METADATA_JSONL_FILE = "transformed_metadata.jsonl";
    static final String METADATA_CSV_FILE = "metadata.csv";
    static final String METADATA_JSONL_FILE = "metadata.jsonl";
    private final CollectService collectService;
    private final MetadataService metadataService;
    private final ProjectRepository projectRepository;
    private final MetadataRepository metadataRepository;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public FluxService(CollectService collectService, MetadataService metadataService, ProjectRepository projectRepository, MetadataRepository metadataRepository, AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.collectService = collectService;
        this.metadataService = metadataService;
        this.projectRepository = projectRepository;
        this.metadataRepository = metadataRepository;
    }

    public void processStream(InputStream inputStreamObject, String projectId, String transactionId, @Nullable String encoding) throws CollectInternalException {
        block35: {
            Optional<ProjectModel> projectById = this.projectRepository.findProjectById(projectId);
            if (projectById.isEmpty()) {
                throw new CollectInternalException("Project not found");
            }
            ProjectModel projectModel = projectById.get();
            try (TempWorkspace tempWorkspace = new TempWorkspace();
                 InputStream inputStreamClosable = StreamUtils.getRemainingReadOnCloseInputStream((InputStream)inputStreamObject);
                 ArchiveInputStream archiveInputStream = new VitamArchiveStreamFactory().createArchiveInputStream(CommonMediaType.ZIP_TYPE, inputStreamClosable, encoding);){
                ArchiveEntry entry;
                boolean isEmpty = true;
                Map<String, String> attachmentUnitsBySystemId = this.metadataService.prepareAttachmentUnits(projectModel, transactionId);
                HashMap<String, String> unitIdsByUploadPath = new HashMap<String, String>();
                File metadataFile = null;
                boolean isCsvMetadataFile = false;
                ArchiveEntryInputStream entryInputStream = new ArchiveEntryInputStream((InputStream)archiveInputStream);
                while ((entry = archiveInputStream.getNextEntry()) != null) {
                    if (archiveInputStream.canReadEntryData(entry)) {
                        this.checkNonEmptyBinary(entry);
                        String path = FilenameUtils.normalize((String)entry.getName());
                        if (!FilenameUtils.equals((String)entry.getName(), (String)path)) {
                            throw new IllegalStateException("path " + path + " is not canonical");
                        }
                        if (Strings.isNullOrEmpty((String)path)) continue;
                        path = FilenameUtils.normalizeNoEndSeparator((String)path);
                        if (!entry.isDirectory() && (path.equals(METADATA_JSONL_FILE) || path.equals(METADATA_CSV_FILE))) {
                            if (metadataFile != null) {
                                throw new CollectInternalInvalidRequestException("Cannot process zip upload for " + projectById.get().getId() + "/" + transactionId + ". Multiple metadata update files found.");
                            }
                            metadataFile = tempWorkspace.writeToFile(path, (InputStream)entryInputStream);
                            isCsvMetadataFile = path.equals(METADATA_CSV_FILE);
                        } else {
                            String staticAttachmentUnitId = attachmentUnitsBySystemId.get(projectModel.getUnitUp());
                            this.createMetadata(tempWorkspace, transactionId, path, (InputStream)entryInputStream, entry.isDirectory(), unitIdsByUploadPath, staticAttachmentUnitId);
                        }
                        isEmpty = false;
                    }
                    entryInputStream.setClosed(false);
                }
                if (isEmpty) {
                    throw new CollectInternalInvalidRequestException("Empty zip file.");
                }
                File validatedJsonlMetadataFile = null;
                if (metadataFile != null) {
                    validatedJsonlMetadataFile = isCsvMetadataFile ? this.csvMetadataToTransformedMetadataFile(tempWorkspace, metadataFile) : this.validateJsonlMetadataFile(metadataFile);
                }
                Map<String, Set<String>> dynamicAttachmentUnitUpsByRootUnitsUploadPath = this.computeDynamicAttachmentUnitUpsForRootUnits(validatedJsonlMetadataFile, projectModel, attachmentUnitsBySystemId);
                this.bulkWriteUnits(tempWorkspace, dynamicAttachmentUnitUpsByRootUnitsUploadPath);
                this.bulkWriteObjectGroups(tempWorkspace);
                if (validatedJsonlMetadataFile == null) break block35;
                try (FileInputStream is = new FileInputStream(validatedJsonlMetadataFile);){
                    this.metadataService.updateUnitsWithJsonlMetadataFile(transactionId, is);
                }
            }
            catch (ZipException | ArchiveException e) {
                throw new CollectInternalInvalidRequestException("Invalid ZIP archive: " + e.getMessage(), e);
            }
            catch (CollectInternalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CollectInternalException("An unexpected error occurs when try to upload the ZIP: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private File csvMetadataToTransformedMetadataFile(TempWorkspace tempWorkspace, File metadataFile) throws CollectInternalException {
        SedaSchemaInfoResolver sedaSchemaInfoResolver = new SedaSchemaInfoResolver(this.adminManagementClientFactory);
        try {
            File tranformedMetadataFile = tempWorkspace.getFile(TRANSFORMED_METADATA_JSONL_FILE);
            try (FileInputStream is = new FileInputStream(metadataFile);){
                CsvHelper.convertCsvToJsonlMetadataFile(sedaSchemaInfoResolver, is, tranformedMetadataFile);
            }
            return tranformedMetadataFile;
        }
        catch (IOException e) {
            throw new CollectInternalServerSideException("An internal error occurred during csv metadata file processing", (Throwable)e);
        }
    }

    private File validateJsonlMetadataFile(File jsonlMetadataFile) throws CollectInternalException {
        JsonlMetadataFileValidator jsonlMetadataFileValidator = new JsonlMetadataFileValidator();
        jsonlMetadataFileValidator.validate(jsonlMetadataFile, true);
        return jsonlMetadataFile;
    }

    private void checkNonEmptyBinary(ArchiveEntry entry) throws CollectInternalInvalidRequestException {
        if (!entry.isDirectory() && entry.getSize() == 0L) {
            throw new CollectInternalInvalidRequestException("Cannot upload empty file '" + entry.getName() + "'");
        }
    }

    private Map<String, Set<String>> computeDynamicAttachmentUnitUpsForRootUnits(File jsonlMetadataFile, ProjectModel projectModel, Map<String, String> attachmentUnitsBySystemId) throws IOException {
        if (projectModel.getUnitUps() == null || jsonlMetadataFile == null) {
            return new HashMap<String, Set<String>>();
        }
        try (JsonLineGenericIterator iterator = new JsonLineGenericIterator((InputStream)new FileInputStream(jsonlMetadataFile), (TypeReference)new TypeReference<CollectJsonMetadataLine>(){});){
            HashMap<String, Set<String>> unitUpsByUploadPath = new HashMap<String, Set<String>>();
            while (iterator.hasNext()) {
                CollectJsonMetadataLine jsonMetadataLine = (CollectJsonMetadataLine)iterator.next();
                String uploadPath = jsonMetadataLine.getFile();
                if (FluxService.isNotRootLevelUnit(uploadPath)) continue;
                ObjectNode unitContent = jsonMetadataLine.getUnitContent();
                Set<String> unitUps = MetadataHelper.findUnitParent(unitContent, projectModel.getUnitUps(), attachmentUnitsBySystemId);
                unitUpsByUploadPath.put(uploadPath, unitUps);
            }
            HashMap<String, Set<String>> hashMap = unitUpsByUploadPath;
            return hashMap;
        }
    }

    private static boolean isNotRootLevelUnit(String uploadPath) {
        return StringUtils.contains((CharSequence)uploadPath, (int)File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMetadata(TempWorkspace tempWorkspace, String transactionId, String path, InputStream entryInputStream, boolean isDirectory, Map<String, String> unitIdsByUploadPath, String staticAttachmentUnitId) throws IOException, CollectInternalException {
        String parentUnit;
        LevelType descriptionLevel = isDirectory ? LevelType.RECORD_GRP : LevelType.ITEM;
        String parentPath = FilenameUtils.getPathNoEndSeparator((String)path);
        if (Strings.isNullOrEmpty((String)parentPath)) {
            parentUnit = staticAttachmentUnitId;
        } else {
            parentUnit = unitIdsByUploadPath.get(parentPath);
            if (parentUnit == null) {
                LOGGER.debug("Creating implicit parent folder '{}'", (Object)parentPath);
                this.createMetadata(tempWorkspace, transactionId, parentPath, null, true, unitIdsByUploadPath, staticAttachmentUnitId);
            }
            parentUnit = unitIdsByUploadPath.get(parentPath);
        }
        String fileName = FilenameUtils.getName((String)path);
        ArchiveUnitModel unit = MetadataHelper.createUnit(transactionId, descriptionLevel, path, fileName, parentUnit);
        unitIdsByUploadPath.put(path, unit.getId());
        if (!isDirectory) {
            String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
            String objectId = GUIDFactory.newGUID().getId();
            String newFilename = Strings.isNullOrEmpty((String)extension) ? objectId : objectId + "." + extension;
            File binaryFile = tempWorkspace.writeToFile(newFilename, entryInputStream);
            try {
                Optional<FormatIdentifierResponse> formatIdentifierResponseOpt = this.collectService.detectFileFormat(binaryFile);
                Map.Entry<String, Long> binaryInformations = this.writeObjectToWorkspace(transactionId, binaryFile, newFilename);
                ObjectGroupResponse objectGroup = MetadataHelper.createObjectGroup(transactionId, fileName, objectId, newFilename, formatIdentifierResponseOpt, binaryInformations.getKey(), binaryInformations.getValue());
                this.writeObjectGroupToTemporaryFile(tempWorkspace, objectGroup);
                unit.setOg(objectGroup.getId());
            }
            finally {
                Files.deleteIfExists(binaryFile.toPath());
            }
        }
        this.writeUnitToTemporaryFile(tempWorkspace, StringUtils.countMatches((CharSequence)path, (CharSequence)File.separator), unit);
    }

    private void bulkWriteUnits(TempWorkspace tempWorkspace, Map<String, Set<String>> unitUps) throws IOException {
        int level = 0;
        File unitFile;
        while ((unitFile = tempWorkspace.getFile(MetadataType.UNIT.getName() + "_" + level + ".jsonl")).exists()) {
            Object unitIterator = new JsonLineGenericIterator((InputStream)new FileInputStream(unitFile), (TypeReference)new TypeReference<ObjectNode>(){});
            if (level == 0 && !unitUps.isEmpty()) {
                unitIterator = IteratorUtils.transformedIterator((Iterator)unitIterator, e -> this.updateParent((ObjectNode)e, unitUps));
            }
            Iterators.partition((Iterator)unitIterator, (int)1000).forEachRemaining(units -> {
                try {
                    this.metadataRepository.saveArchiveUnits((List<ObjectNode>)units);
                }
                catch (CollectInternalException e) {
                    throw new RuntimeException(e);
                }
            });
            ++level;
        }
        return;
    }

    private ObjectNode updateParent(ObjectNode unit, Map<String, Set<String>> unitUps) {
        String unitUploadPath = unit.get(VitamFieldsHelper.uploadPath()).asText();
        Set<String> dynamicAttachmentParentUnitIds = unitUps.get(unitUploadPath);
        if (CollectionUtils.isNotEmpty(dynamicAttachmentParentUnitIds)) {
            unit.set(VitamFieldsHelper.unitups(), (JsonNode)JsonHandler.createStringArrayNode(dynamicAttachmentParentUnitIds));
        }
        return unit;
    }

    private void bulkWriteObjectGroups(TempWorkspace tempWorkspace) throws IOException {
        File ogFile = tempWorkspace.getFile(MetadataType.OBJECTGROUP.getName() + ".jsonl");
        if (!ogFile.exists()) {
            LOGGER.info("No object group to insert");
            return;
        }
        JsonLineGenericIterator ogIterator = new JsonLineGenericIterator((InputStream)new FileInputStream(ogFile), (TypeReference)new TypeReference<ObjectNode>(){});
        Iterators.partition((Iterator)ogIterator, (int)1000).forEachRemaining(objectGroups -> {
            try {
                this.metadataRepository.saveObjectGroups((List<ObjectNode>)objectGroups);
            }
            catch (CollectInternalException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void writeObjectGroupToTemporaryFile(TempWorkspace tempWorkspace, Object objectGroup) throws IOException {
        File file = tempWorkspace.getFile(MetadataType.OBJECTGROUP.getName() + ".jsonl");
        try (JsonLineWriter writer = new JsonLineWriter((OutputStream)new FileOutputStream(file, true), file.length() == 0L);){
            JsonNode objectGroupToSave = (JsonNode)VitamObjectMapper.getSerializationObjectMapper().convertValue(objectGroup, JsonNode.class);
            writer.addEntry((Object)objectGroupToSave);
        }
    }

    private void writeUnitToTemporaryFile(TempWorkspace tempWorkspace, int level, Object unit) throws IOException {
        File file = tempWorkspace.getFile(MetadataType.UNIT.getName() + "_" + level + ".jsonl");
        try (JsonLineWriter writer = new JsonLineWriter((OutputStream)new FileOutputStream(file, true), file.length() == 0L);){
            JsonNode unitToSave = (JsonNode)VitamObjectMapper.getSerializationObjectMapper().convertValue(unit, JsonNode.class);
            writer.addEntry((Object)unitToSave);
        }
    }

    private Map.Entry<String, Long> writeObjectToWorkspace(String transactionId, File fileToWrite, String fileName) throws IOException, CollectInternalException {
        try (CountingInputStream countingInputStream = new CountingInputStream((InputStream)new FileInputStream(fileToWrite));){
            String digest = this.collectService.pushStreamToWorkspace(transactionId, (InputStream)countingInputStream, "Content".concat(File.separator).concat(fileName));
            AbstractMap.SimpleEntry<String, Long> simpleEntry = new AbstractMap.SimpleEntry<String, Long>(digest, countingInputStream.getByteCount());
            return simpleEntry;
        }
    }
}

