/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers.builders;

import com.fasterxml.jackson.annotation.JsonInclude;
import fr.gouv.vitam.collect.internal.core.common.ManifestContext;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ManifestContextBuilder {
    private String acquisitionInformation;
    private String legalStatus;
    private String archivalAgreement;
    private String messageIdentifier;
    private String archivalAgencyIdentifier;
    private String transferringAgencyIdentifier;
    private String originatingAgencyIdentifier;
    private String submissionAgencyIdentifier;
    private String archivalProfile;
    private String comment;

    public ManifestContextBuilder withArchivalAgreement(String archivalAgreement) {
        this.archivalAgreement = archivalAgreement;
        return this;
    }

    public ManifestContextBuilder withMessageIdentifier(String messageIdentifier) {
        this.messageIdentifier = messageIdentifier;
        return this;
    }

    public ManifestContextBuilder withArchivalAgencyIdentifier(String archivalAgencyIdentifier) {
        this.archivalAgencyIdentifier = archivalAgencyIdentifier;
        return this;
    }

    public ManifestContextBuilder withTransferringAgencyIdentifier(String transferingAgencyIdentifier) {
        this.transferringAgencyIdentifier = transferingAgencyIdentifier;
        return this;
    }

    public ManifestContextBuilder withOriginatingAgencyIdentifier(String originatingAgencyIdentifier) {
        this.originatingAgencyIdentifier = originatingAgencyIdentifier;
        return this;
    }

    public ManifestContextBuilder withSubmissionAgencyIdentifier(String submissionAgencyIdentifier) {
        this.submissionAgencyIdentifier = submissionAgencyIdentifier;
        return this;
    }

    public ManifestContextBuilder withArchivalProfile(String archivalProfile) {
        this.archivalProfile = archivalProfile;
        return this;
    }

    public ManifestContextBuilder withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public ManifestContextBuilder withAcquisitionInformation(String acquisitionInformation) {
        this.acquisitionInformation = acquisitionInformation;
        return this;
    }

    public ManifestContextBuilder withLegalStatus(String legalStatus) {
        this.legalStatus = legalStatus;
        return this;
    }

    public ManifestContext build() {
        return new ManifestContext(this.acquisitionInformation, this.legalStatus, this.archivalAgreement, this.messageIdentifier, this.archivalAgencyIdentifier, this.transferringAgencyIdentifier, this.originatingAgencyIdentifier, this.submissionAgencyIdentifier, this.archivalProfile, this.comment);
    }
}

