/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers.builders;

import fr.gouv.vitam.collect.internal.core.helpers.builders.DbQualifiersModelBuilder;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.DbFileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.DbObjectGroupModel;
import fr.gouv.vitam.common.model.objectgroup.DbQualifiersModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DbObjectGroupModelBuilder {
    private String id;
    private String opi;
    private DbFileInfoModel fileInfoModel;
    private List<DbQualifiersModel> qualifiers;

    public DbObjectGroupModelBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public DbObjectGroupModelBuilder withOpi(String opi) {
        this.opi = opi;
        return this;
    }

    public DbObjectGroupModelBuilder withQualifiers(List<DbQualifiersModel> qualifiers) {
        this.qualifiers = qualifiers;
        return this;
    }

    public DbObjectGroupModelBuilder withQualifiers(String versionId, String fileName, DataObjectVersionType usage, Integer version) {
        this.qualifiers = Collections.singletonList(new DbQualifiersModelBuilder().withUsage(usage).withVersion(versionId, fileName, usage, version).withNbc(1).build());
        return this;
    }

    public DbObjectGroupModelBuilder withFileInfoModel(String fileName) {
        Objects.requireNonNull(fileName, "FileName can't be null");
        this.fileInfoModel = new DbFileInfoModel();
        this.fileInfoModel.setFilename(fileName);
        return this;
    }

    public DbObjectGroupModel build() {
        Objects.requireNonNull(this.id, "Id can't be null");
        Objects.requireNonNull(this.opi, "Opi can't be null");
        Objects.requireNonNull(this.fileInfoModel, "FileInfoModel can't be null");
        Objects.requireNonNull(this.qualifiers, "QualifiersModel can't be null");
        DbObjectGroupModel model = new DbObjectGroupModel();
        model.setId(this.id);
        model.setOpi(this.opi);
        model.setFileInfo(this.fileInfoModel);
        int nbc = this.qualifiers.stream().map(DbQualifiersModel::getNbc).reduce(Integer::sum).orElse(0);
        model.setNbc(nbc);
        model.setQualifiers(this.qualifiers);
        return model;
    }
}

