/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers;

import fr.gouv.vitam.collect.internal.core.service.FluxService;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;

public class TempWorkspace
implements AutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FluxService.class);
    private final File tmpFolder;

    public TempWorkspace() throws IOException {
        try {
            File tmpFolder = SafeFileChecker.checkSafeFilePath((String)VitamConfiguration.getVitamTmpFolder(), (String[])new String[]{GUIDFactory.newGUID().getId()});
            if (!tmpFolder.mkdirs()) {
                throw new VitamRuntimeException("Cannot create tmp folder: " + tmpFolder.getAbsoluteFile());
            }
            this.tmpFolder = tmpFolder;
        }
        catch (IllegalPathException e) {
            throw new IOException("Cannot create temporary folder", e);
        }
    }

    public File writeToFile(String filename, InputStream inputStream) throws IOException {
        File tmpFile = this.getFile(filename);
        Files.copy(inputStream, tmpFile.toPath(), new CopyOption[0]);
        return tmpFile;
    }

    public File getFile(String filename) throws IOException {
        try {
            return SafeFileChecker.checkSafeFilePath((String)this.tmpFolder.getAbsolutePath(), (String[])new String[]{filename});
        }
        catch (IllegalPathException e) {
            throw new IOException("Cannot create tmp file", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            FileUtils.deleteDirectory((File)this.tmpFolder);
        }
        catch (IOException e) {
            LOGGER.error("Cannot cleanup tmp folder " + this.tmpFolder);
        }
    }
}

