/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import fr.gouv.vitam.collect.common.dto.MetadataUnitUp;
import fr.gouv.vitam.collect.internal.core.common.CollectArchiveUnitModel;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.FileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.FormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.objectgroup.QualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.VersionsModel;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.model.unit.DescriptiveMetadataModel;
import fr.gouv.vitam.common.model.unit.LevelType;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public class MetadataHelper {
    public static final String STATIC_ATTACHMENT = "STATIC_ATTACHEMENT";
    public static final String DYNAMIC_ATTACHEMENT = "DYNAMIC_ATTACHEMENT";

    private MetadataHelper() {
    }

    public static ArchiveUnitModel createUnit(String transactionId, LevelType descriptionLevel, String path, String title, String unitParent) {
        String id = GUIDFactory.newUnitGUID((int)VitamThreadUtils.getVitamSession().getTenantId()).getId();
        CollectArchiveUnitModel unitInternalModel = new CollectArchiveUnitModel();
        unitInternalModel.setId(id);
        unitInternalModel.setOpi(transactionId);
        unitInternalModel.setUnitType(UnitType.INGEST);
        unitInternalModel.setUploadPath(path);
        unitInternalModel.setBatchId(VitamThreadUtils.getVitamSession().getRequestId());
        DescriptiveMetadataModel description = new DescriptiveMetadataModel();
        description.setTitle(title);
        description.setDescriptionLevel(descriptionLevel);
        unitInternalModel.setDescriptiveMetadataModel(description);
        if (unitParent != null) {
            unitInternalModel.setUnitups(Collections.singletonList(unitParent));
        }
        return unitInternalModel;
    }

    public static ObjectGroupResponse createObjectGroup(String transactionId, String fileName, String objectId, String newFilename, Optional<FormatIdentifierResponse> formatOpt, String digest, Long size) {
        FileInfoModel fileInfoModel = new FileInfoModel();
        fileInfoModel.setFilename(fileName);
        fileInfoModel.setLastModified(LocalDateUtil.nowFormatted());
        QualifiersModel qualifiersModel = new QualifiersModel();
        VersionsModel versionsModel = new VersionsModel();
        versionsModel.setId(objectId);
        versionsModel.setFileInfoModel(fileInfoModel);
        versionsModel.setDataObjectVersion(DataObjectVersionType.BINARY_MASTER.getName() + "_1");
        versionsModel.setMessageDigest(digest);
        versionsModel.setAlgorithm(VitamConfiguration.getDefaultDigestType().getName());
        versionsModel.setSize(size.longValue());
        versionsModel.setUri("Content" + File.separator + newFilename);
        versionsModel.setOpi(transactionId);
        if (formatOpt.isPresent()) {
            FormatIdentifierResponse format = formatOpt.get();
            FormatIdentificationModel formatIdentificationModel = new FormatIdentificationModel();
            formatIdentificationModel.setFormatId(format.getPuid());
            formatIdentificationModel.setMimeType(format.getMimetype());
            formatIdentificationModel.setFormatLitteral(format.getFormatLiteral());
            versionsModel.setFormatIdentification(formatIdentificationModel);
        }
        qualifiersModel.setQualifier(DataObjectVersionType.BINARY_MASTER.getName());
        qualifiersModel.setVersions(Collections.singletonList(versionsModel));
        qualifiersModel.setNbc("1");
        ObjectGroupResponse dbObjectGroupModel = new ObjectGroupResponse();
        dbObjectGroupModel.setId(GUIDFactory.newObjectGroupGUID((int)ParameterHelper.getTenantParameter()).getId());
        dbObjectGroupModel.setOpi(transactionId);
        dbObjectGroupModel.setBatchId(VitamThreadUtils.getVitamSession().getRequestId());
        dbObjectGroupModel.setFileInfo(fileInfoModel);
        dbObjectGroupModel.setNbc(1);
        dbObjectGroupModel.setQualifiers(Collections.singletonList(qualifiersModel));
        return dbObjectGroupModel;
    }

    public static Set<String> findUnitParent(ObjectNode unit, @Nonnull List<MetadataUnitUp> unitUps, Map<String, String> attachmentUnitsBySystemId) {
        HashSet<String> attachmentUnits = new HashSet<String>();
        for (MetadataUnitUp metadataUnitUp : unitUps) {
            if (!MetadataHelper.metadataMatches((JsonNode)unit, metadataUnitUp.getMetadataKey(), metadataUnitUp.getMetadataValue())) continue;
            String unitUpId = attachmentUnitsBySystemId.get(metadataUnitUp.getUnitUp());
            attachmentUnits.add(unitUpId);
        }
        return attachmentUnits;
    }

    private static boolean metadataMatches(JsonNode objectNode, String path, String value) {
        if (Strings.isNullOrEmpty((String)path)) {
            if (objectNode.isTextual() || objectNode.isNumber()) {
                return objectNode.asText().equals(value);
            }
            return false;
        }
        String[] paths = path.split("\\.");
        JsonNode obj = objectNode.get(paths[0]);
        if (obj == null || obj.isNull()) {
            return false;
        }
        if (paths.length == 1 && (obj.isNumber() || obj.isTextual())) {
            return obj.asText().equals(value);
        }
        if (obj.isObject()) {
            return MetadataHelper.metadataMatches(obj, Arrays.stream(paths).skip(1L).collect(Collectors.joining(".")), value);
        }
        if (obj.isArray()) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(obj.elements(), 16), false).map(e -> MetadataHelper.metadataMatches(e, Arrays.stream(paths).skip(1L).collect(Collectors.joining(".")), value)).reduce(false, Boolean::logicalOr);
        }
        return false;
    }

    public static void applyTransactionToQuery(String transactionId, RequestMultiple select) throws InvalidCreateOperationException {
        InQuery inQuery = QueryHelper.in((String)VitamFieldsHelper.initialOperation(), (String[])new String[]{transactionId});
        List queries = select.getQueries();
        if (queries.isEmpty()) {
            queries.add(inQuery);
        } else {
            ArrayList queryList = new ArrayList(queries);
            Query lastQuery = (Query)queryList.get(queryList.size() - 1);
            BooleanQuery mergedQuery = QueryHelper.and().add(new Query[]{lastQuery, inQuery});
            queries.set(queryList.size() - 1, mergedQuery);
        }
    }
}

