/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import fr.gouv.vitam.collect.internal.core.csv.CsvErrorAccumulator;
import fr.gouv.vitam.collect.internal.core.csv.CsvHelper;
import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataUtils;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidCsvFormatException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class CsvHeaderValidationManager
implements AutoCloseable {
    private final LinkedHashSet<String> headerNames;
    private final Set<String> invalidHeaderNames = new HashSet<String>();
    private final CsvErrorAccumulator errorAccumulator = new CsvErrorAccumulator();

    public CsvHeaderValidationManager(List<String> headerNames) {
        this.headerNames = new LinkedHashSet<String>(headerNames);
    }

    public Iterable<String> getRemainingHeaderNamesToValidate() {
        return () -> this.headerNames.stream().filter(Predicate.not(this.invalidHeaderNames::contains)).iterator();
    }

    public Iterable<String> getRemainingHeaderNamesToValidate(Predicate<String> filter) {
        return () -> this.headerNames.stream().filter(Predicate.not(this.invalidHeaderNames::contains)).filter(filter).iterator();
    }

    public Iterable<String> getRemainingHeaderNamesToValidateByPrefix(String prefix) {
        return this.getRemainingHeaderNamesToValidate(headerName -> CsvMetadataUtils.equalsOrStartsWith(headerName, prefix));
    }

    public Iterable<String> getRemainingContentHeaderNamesToValidate() {
        return this.getRemainingHeaderNamesToValidate(CsvMetadataUtils::isContentField);
    }

    public Iterable<String> getRemainingMainContentHeaderNamesToValidate() {
        return this.getRemainingHeaderNamesToValidate(headerName -> !CsvMetadataUtils.isContentTitleField(headerName) && !CsvMetadataUtils.isContentDescriptionField(headerName));
    }

    public Iterable<String> getRemainingManagementHeaderNamesToValidate() {
        return this.getRemainingHeaderNamesToValidate(CsvMetadataUtils::isManagementField);
    }

    public boolean containsHeaderName(String headerName) {
        return this.headerNames.contains(headerName);
    }

    public void report(String headerName, String message) throws CollectInvalidCsvFormatException {
        if (!this.headerNames.contains(headerName)) {
            throw new IllegalStateException("Invalid header name " + headerName + " (msg=" + message + ")");
        }
        this.invalidHeaderNames.add(headerName);
        this.errorAccumulator.report("Invalid header name '" + CsvHelper.sanitizeStringForLog(headerName, 255) + "': " + message);
    }

    @Override
    public void close() throws CollectInvalidCsvFormatException {
        this.errorAccumulator.close();
    }
}

