/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidCsvFormatException;
import java.util.ArrayList;
import java.util.List;

public class CsvErrorAccumulator
implements AutoCloseable {
    private static final int MAX_ERROR_COUNT = 20;
    private final List<String> errorMessages = new ArrayList<String>();

    public void report(String errorMessage) throws CollectInvalidCsvFormatException {
        this.errorMessages.add(errorMessage);
        if (this.errorMessages.size() >= 20) {
            throw this.buildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectInvalidCsvFormatException buildException() {
        try {
            StringBuilder stringBuilder = new StringBuilder("CSV validation failed. ");
            if (this.errorMessages.size() == 1) {
                stringBuilder.append("1 error:");
            } else if (this.errorMessages.size() < 20) {
                stringBuilder.append(this.errorMessages.size()).append(" errors:");
            } else {
                stringBuilder.append("At least ").append(this.errorMessages.size()).append(" errors:");
            }
            for (String errorMessage : this.errorMessages) {
                stringBuilder.append("\n- ").append(errorMessage);
            }
            Object object = new CollectInvalidCsvFormatException(stringBuilder.toString());
            return object;
        }
        finally {
            this.errorMessages.clear();
        }
    }

    @Override
    public void close() throws CollectInvalidCsvFormatException {
        if (!this.errorMessages.isEmpty()) {
            throw this.buildException();
        }
    }
}

