/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.swift;

import com.google.common.base.Preconditions;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.openstack4j.api.OSClient;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectListOptions;
import org.openstack4j.model.storage.object.options.ObjectLocation;
import org.openstack4j.model.storage.object.options.ObjectPutOptions;
import org.openstack4j.openstack.storage.object.domain.SwiftObjectImpl;
import org.openstack4j.openstack.storage.object.functions.MapWithoutMetaPrefixFunction;
import org.openstack4j.openstack.storage.object.functions.ParseObjectFunction;
import org.openstack4j.openstack.storage.object.internal.BaseObjectStorageService;

@NotThreadSafe
public class VitamSwiftObjectStorageService
extends BaseObjectStorageService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamSwiftObjectStorageService.class);
    private static final String CONTENT_LENGTH = "Content-Length";

    public VitamSwiftObjectStorageService(Supplier<OSClient> osClientFactory) {
        this.initializeClient(osClientFactory);
    }

    private void initializeClient(Supplier<OSClient> osClientFactory) {
        osClientFactory.get();
    }

    public List<? extends SwiftObject> list(String containerName, ObjectListOptions options, Map<String, String> headers) throws ContentAddressableStorageException {
        Preconditions.checkNotNull((Object)containerName);
        Map params = options != null ? options.getOptions() : Collections.emptyMap();
        LOGGER.debug("Listing container {} with params {}", (Object)containerName, (Object)params);
        HttpResponse resp = this.get(Void.class, new String[]{this.uri("/%s", new Object[]{containerName})}).param("format", (Object)"json").params(params).headers(headers).executeWithResponse();
        try {
            if (this.isSuccessResponse(resp)) {
                List objects = (List)resp.getEntity(SwiftObjectImpl.SwiftObjects.class);
                LOGGER.debug("Listing container {} returned {} entries", (Object)containerName, (Object)objects.size());
                List list = objects;
                return list;
            }
            if (this.isNotFoundResponse(resp)) {
                throw new ContentAddressableStorageNotFoundException(containerName + " not found");
            }
            throw new ContentAddressableStorageException("Could not get list objects for container " + containerName + " with params " + params + ". Got status code: " + resp.getStatus());
        }
        finally {
            HttpEntityHandler.closeQuietly((HttpResponse)resp);
        }
    }

    public Optional<SwiftObject> getObjectInformation(String containerName, String objectName, Map<String, String> headers) throws ContentAddressableStorageException {
        Preconditions.checkNotNull((Object)containerName);
        Preconditions.checkNotNull((Object)objectName);
        ObjectLocation location = ObjectLocation.create((String)containerName, (String)objectName);
        LOGGER.debug("Getting object information {}/{}", (Object)location.getContainerName(), (Object)location.getObjectName());
        HttpResponse resp = this.head(Void.class, new String[]{location.getURI()}).headers(headers).executeWithResponse();
        try {
            if (this.isNotFoundResponse(resp)) {
                LOGGER.debug("Object {}/{} Not Found", (Object)location.getContainerName(), (Object)location.getObjectName());
                Optional<SwiftObject> optional = Optional.empty();
                return optional;
            }
            if (this.isSuccessResponse(resp)) {
                LOGGER.debug("Getting object information {}/{} succeeded", (Object)location.getContainerName(), (Object)location.getObjectName());
                Optional<SwiftObject> optional = Optional.of(ParseObjectFunction.create((ObjectLocation)location).apply(resp));
                return optional;
            }
            throw new ContentAddressableStorageException("Get object information " + location.getContainerName() + "/" + location.getObjectName() + " failed with unexpected status code: " + resp.getStatus());
        }
        finally {
            HttpEntityHandler.closeQuietly((HttpResponse)resp);
        }
    }

    public ObjectContent download(String containerName, String objectName, Map<String, String> headers) throws ContentAddressableStorageException {
        Preconditions.checkNotNull((Object)containerName);
        Preconditions.checkNotNull((Object)objectName);
        ObjectLocation location = ObjectLocation.create((String)containerName, (String)objectName);
        LOGGER.debug("Getting object {}/{}", (Object)location.getContainerName(), (Object)location.getObjectName());
        HttpResponse resp = this.get(Void.class, new String[]{location.getURI()}).headers(headers).executeWithResponse();
        boolean keepResponseOpen = false;
        try {
            if (this.isSuccessResponse(resp)) {
                LOGGER.debug("Getting object {}/{} succeeded", (Object)containerName, (Object)objectName);
                keepResponseOpen = true;
                String contentLengthStr = resp.header(CONTENT_LENGTH);
                if (contentLengthStr == null) {
                    throw new ContentAddressableStorageException("Could not read object length for " + location.getContainerName() + "/" + location.getObjectName());
                }
                long contentLength = Long.parseLong(contentLengthStr);
                AutoCloseResponseInputStream inputStream = new AutoCloseResponseInputStream(resp);
                ObjectContent objectContent = new ObjectContent((InputStream)((Object)inputStream), contentLength);
                return objectContent;
            }
            if (this.isNotFoundResponse(resp)) {
                throw new ContentAddressableStorageNotFoundException("Object not found " + containerName + "/" + objectName);
            }
            throw new ContentAddressableStorageException("Get object " + location.getContainerName() + "/" + location.getObjectName() + " failed with unexpected status code: " + resp.getStatus());
        }
        finally {
            if (!keepResponseOpen) {
                HttpEntityHandler.closeQuietly((HttpResponse)resp);
            }
        }
    }

    public void put(String containerName, String name, Payload<?> payload) throws ContentAddressableStorageException {
        this.put(containerName, name, payload, ObjectPutOptions.NONE);
    }

    public void put(String containerName, String objectName, Payload<?> payload, ObjectPutOptions options) throws ContentAddressableStorageException {
        Preconditions.checkNotNull((Object)containerName);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull(payload);
        Preconditions.checkNotNull((Object)objectName);
        if (options.getPath() != null && ((String)objectName).indexOf(47) == -1) {
            objectName = options.getPath() + "/" + (String)objectName;
        }
        LOGGER.debug("Uploading object {}/{}", (Object)containerName, objectName);
        HttpResponse resp = this.put(Void.class, new String[]{this.uri("/%s/%s", new Object[]{containerName, objectName})}).entity(payload).headers(options.getOptions()).contentType(options.getContentType()).paramLists(options.getQueryParams()).executeWithResponse();
        try {
            if (this.isSuccessResponse(resp)) {
                LOGGER.debug("Object uploaded successfully {}/{}", (Object)containerName, objectName);
                return;
            }
            if (this.isNotFoundResponse(resp)) {
                throw new ContentAddressableStorageNotFoundException(containerName + " not found");
            }
            throw new ContentAddressableStorageException("Could not upload object " + containerName + "/" + (String)objectName + ". Got status code: " + resp.getStatus());
        }
        finally {
            HttpEntityHandler.closeQuietly((HttpResponse)resp);
        }
    }

    public void deleteFullObject(String containerName, String objectName, List<String> objectNameSegments, Map<String, String> headers) throws ContentAddressableStorageException {
        Preconditions.checkNotNull((Object)containerName);
        Preconditions.checkNotNull((Object)objectName);
        if (CollectionUtils.isNotEmpty(objectNameSegments)) {
            for (String objectNameSegment : objectNameSegments) {
                ObjectLocation segmentLocation = ObjectLocation.create((String)containerName, (String)objectNameSegment);
                HttpResponse respForDeletedSegment = this.delete(Void.class, new String[]{segmentLocation.getURI()}).executeWithResponse();
                LOGGER.debug("Deleting object segment {}/{}", (Object)segmentLocation.getContainerName(), (Object)segmentLocation.getObjectName());
                if (!this.isNotFoundResponse(respForDeletedSegment)) continue;
                LOGGER.debug("Cannot delete object segment. Not found {}/{}", (Object)segmentLocation.getContainerName(), (Object)segmentLocation.getObjectName());
                throw new ContentAddressableStorageNotFoundException("Object segment not found " + segmentLocation.getContainerName() + "/" + segmentLocation.getObjectName());
            }
            LOGGER.debug("Object segments sized {} for manifest {} were deleted successfully.", (Object)objectNameSegments.size(), (Object)objectName);
        }
        ObjectLocation location = ObjectLocation.create((String)containerName, (String)objectName);
        LOGGER.debug("Deleting object {}/{}", (Object)location.getContainerName(), (Object)location.getObjectName());
        HttpResponse resp = this.delete(Void.class, new String[]{location.getURI()}).headers(headers).executeWithResponse();
        try {
            if (this.isSuccessResponse(resp)) {
                LOGGER.debug("Object deleted successfully {}/{}", (Object)location.getContainerName(), (Object)location.getObjectName());
                return;
            }
            if (this.isNotFoundResponse(resp)) {
                LOGGER.debug("Cannot delete object. Not found {}/{}", (Object)location.getContainerName(), (Object)location.getObjectName());
                throw new ContentAddressableStorageNotFoundException("Object not found " + location.getContainerName() + "/" + location.getObjectName());
            }
            throw new ContentAddressableStorageException("Could not delete object " + location.getContainerName() + "/" + location.getObjectName() + ". Got status code: " + resp.getStatus());
        }
        finally {
            HttpEntityHandler.closeQuietly((HttpResponse)resp);
        }
    }

    public Map<String, String> getMetadata(String containerName, String objectName, Map<String, String> headers) throws ContentAddressableStorageException {
        Preconditions.checkNotNull((Object)containerName, (Object)objectName);
        LOGGER.debug("Getting metadata for object {}/{}", (Object)containerName, (Object)objectName);
        ObjectLocation location = ObjectLocation.create((String)containerName, (String)objectName);
        HttpResponse resp = this.head(Void.class, new String[]{location.getURI()}).headers(headers).executeWithResponse();
        try {
            if (this.isSuccessResponse(resp)) {
                LOGGER.debug("Metadata retrieved successfully for object {}/{}", (Object)location.getContainerName(), (Object)location.getObjectName());
                TreeMap<String, String> metadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                metadata.putAll(MapWithoutMetaPrefixFunction.INSTANCE.apply(resp.headers()));
                TreeMap<String, String> treeMap = metadata;
                return treeMap;
            }
            if (this.isNotFoundResponse(resp)) {
                throw new ContentAddressableStorageNotFoundException("No such object " + location.getContainerName() + "/" + location.getObjectName());
            }
            throw new ContentAddressableStorageException("Could not get metadata for object " + location.getContainerName() + "/" + location.getObjectName() + ". Got status code: " + resp.getStatus());
        }
        finally {
            HttpEntityHandler.closeQuietly((HttpResponse)resp);
        }
    }

    public void updateMetadata(ObjectLocation location, Map<String, String> headers) throws ContentAddressableStorageException {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull(headers);
        LOGGER.debug("Updating metadata for object {}/{} with headers {}", new Object[]{location.getContainerName(), location.getObjectName(), headers});
        HttpResponse resp = this.post(Void.class, new String[]{location.getURI()}).headers(headers).executeWithResponse();
        try {
            if (this.isSuccessResponse(resp)) {
                LOGGER.debug("Metadata updated successfully for object {}/{}", (Object)location.getContainerName(), (Object)location.getObjectName());
                return;
            }
            throw new ContentAddressableStorageException("Could not update metadata for object " + location.getContainerName() + "/" + location.getObjectName() + ". Got status code: " + resp.getStatus());
        }
        finally {
            HttpEntityHandler.closeQuietly((HttpResponse)resp);
        }
    }

    private boolean isSuccessResponse(HttpResponse httpResponse) {
        return httpResponse.getStatus() >= 200 && httpResponse.getStatus() <= 299;
    }

    private boolean isNotFoundResponse(HttpResponse resp) {
        return resp.getStatus() == 404;
    }

    private static final class AutoCloseResponseInputStream
    extends ProxyInputStream {
        private final HttpResponse resp;

        public AutoCloseResponseInputStream(HttpResponse resp) {
            super(resp.getInputStream());
            this.resp = resp;
        }

        public void close() throws IOException {
            super.close();
            this.resp.close();
        }
    }
}

