/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.compress;

import fr.gouv.vitam.common.CommonMediaType;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang3.StringUtils;

public class VitamArchiveStreamFactory {
    public ArchiveInputStream createArchiveInputStream(MediaType mediaType, InputStream in) throws IOException, ArchiveException {
        return this.createArchiveInputStream(mediaType, in, null);
    }

    public ArchiveInputStream createArchiveInputStream(MediaType mediaType, InputStream in, @Nullable String encoding) throws ArchiveException, IOException {
        if (mediaType == null) {
            throw new IllegalArgumentException("archiverMediaType must not be null.");
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = "UTF-8";
        }
        switch (CommonMediaType.mimeTypeOf((MediaType)mediaType)) {
            case "application/zip": {
                return new ZipArchiveInputStream(in, encoding);
            }
            case "application/x-tar": {
                return new TarArchiveInputStream(in, encoding);
            }
            case "application/x-gzip": 
            case "application/gzip": {
                return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in), encoding);
            }
            case "application/x-bzip2": {
                return new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(in), encoding);
            }
        }
        throw new ArchiveException("Archive: " + mediaType + " not found.");
    }
}

