/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.cas.container.api;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageUnavailableDataFromAsyncOfferException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface ContentAddressableStorage
extends VitamAutoCloseable {
    public void createContainer(String var1) throws ContentAddressableStorageServerException;

    public boolean isExistingContainer(String var1) throws ContentAddressableStorageServerException;

    public void writeObject(String var1, String var2, InputStream var3, DigestType var4, long var5) throws ContentAddressableStorageException;

    public void checkObjectDigestAndStoreDigest(String var1, String var2, String var3, DigestType var4, long var5) throws ContentAddressableStorageException;

    @VisibleForTesting
    default public String putObject(String containerName, String objectName, InputStream inputStream, DigestType digestType, long size) throws ContentAddressableStorageException {
        Digest digest = new Digest(digestType);
        InputStream digestInputStream = digest.getDigestInputStream(inputStream);
        this.writeObject(containerName, objectName, digestInputStream, digestType, size);
        String objectDigest = digest.digestHex();
        this.checkObjectDigestAndStoreDigest(containerName, objectName, objectDigest, digestType, size);
        return objectDigest;
    }

    public ObjectContent getObject(String var1, String var2) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageException, ContentAddressableStorageUnavailableDataFromAsyncOfferException;

    default public String createAccessRequest(String containerName, List<String> objectNames) throws ContentAddressableStorageException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    default public Map<String, AccessRequestStatus> checkAccessRequestStatuses(List<String> accessRequestIds, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    default public void removeAccessRequest(String accessRequestId, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    default public boolean checkObjectAvailability(String containerName, List<String> objectNames) throws ContentAddressableStorageException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void deleteObject(String var1, String var2) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageException;

    public boolean isExistingObject(String var1, String var2) throws ContentAddressableStorageException;

    public String getObjectDigest(String var1, String var2, DigestType var3, boolean var4) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException, ContentAddressableStorageException;

    public ContainerInformation getContainerInformation(String var1) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException;

    public MetadatasObject getObjectMetadata(String var1, String var2, boolean var3) throws ContentAddressableStorageException;

    public void listContainer(String var1, ObjectListingListener var2) throws ContentAddressableStorageException, IOException;
}

